/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Player;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00122\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017J\u0016\u0010\u0018\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u0010\u001b\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0019J\u0016\u0010\u001c\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0019J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u001e\u0010\u001f\u001a\u00020 2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u000bJ\u0006\u0010#\u001a\u00020 J\b\u0010$\u001a\u00020 H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/panopset/blackjackEngine/Bankroll;", "", "<init>", "()V", "reloadAmount", "", "getReloadAmount", "()I", "setReloadAmount", "(I)V", "reloadCount", "", "getReloadCount", "()J", "setReloadCount", "(J)V", "chips", "toString", "", "showBankrollStatus", "players", "Ljava/util/ArrayList;", "Lcom/panopset/blackjackEngine/Player;", "Lkotlin/collections/ArrayList;", "getStakeIncludingHands", "", "getStakeOutOfPlay", "getTableChips", "getLiveValue", "subtract", "value", "settle", "", "add", "getChips", "reset", "reload", "blackjackEngine"})
public final class Bankroll {
    private int reloadAmount = 30000;
    private long reloadCount;
    private long chips;

    public final int getReloadAmount() {
        return this.reloadAmount;
    }

    public final void setReloadAmount(int n) {
        this.reloadAmount = n;
    }

    public final long getReloadCount() {
        return this.reloadCount;
    }

    public final void setReloadCount(long l) {
        this.reloadCount = l;
    }

    @NotNull
    public String toString() {
        return "Chips: " + this.getChips() + ", reloadAmount: " + this.reloadAmount + ", reloadCount: " + this.reloadCount;
    }

    @NotNull
    public final String showBankrollStatus(@NotNull ArrayList<Player> players) {
        Intrinsics.checkNotNullParameter(players, "players");
        return "Chips: " + this.getChips() + "  stake: " + this.getStakeIncludingHands((List<Player>)players);
    }

    public final long getStakeIncludingHands(@Nullable List<Player> players) {
        return this.getChips() + this.getLiveValue(players) - (long)this.reloadAmount * this.reloadCount;
    }

    public final long getStakeOutOfPlay() {
        return this.getChips() - (long)this.reloadAmount * this.reloadCount;
    }

    public final long getTableChips(@Nullable List<Player> players) {
        return this.getChips() + this.getLiveValue(players);
    }

    public final long getLiveValue(@Nullable List<Player> players) {
        long liveValue = 0L;
        if (players != null) {
            for (Player player : players) {
                Iterator<HandPlayer> iterator2;
                if (player.isSettled()) continue;
                Intrinsics.checkNotNullExpressionValue(player.getHands().iterator(), "iterator(...)");
                while (iterator2.hasNext()) {
                    HandPlayer hand;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                    liveValue += hand.getWager().getLiveValue();
                }
            }
        }
        return liveValue;
    }

    public final int subtract(int value) {
        this.chips -= (long)value;
        if (this.chips < 1L) {
            this.reload();
        }
        return value;
    }

    public final void settle(@NotNull ArrayList<Player> players) {
        Intrinsics.checkNotNullParameter(players, "players");
        Iterator<Player> iterator2 = players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Iterator<HandPlayer> iterator4;
            Player player;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!player.isFinal()) {
                throw new RuntimeException("Attempt to settle player that is not final, logic error.");
            }
            if (player.isSettled()) {
                throw new RuntimeException("Attempt to settle a player twice, logic error.");
            }
            Intrinsics.checkNotNullExpressionValue(player.getHands().iterator(), "iterator(...)");
            while (iterator4.hasNext()) {
                HandPlayer hand;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                this.chips += hand.getWager().getLiveValue();
                player.setSettled(true);
            }
        }
    }

    public final void add(int value) {
        this.chips += (long)value;
    }

    public final long getChips() {
        if (this.reloadAmount == 0) {
            throw new RuntimeException("Reload amount can't be 0.");
        }
        if (this.chips < 1L) {
            this.reload();
        }
        return this.chips;
    }

    public final void reset() {
        this.chips = 0L;
        this.reloadCount = 0L;
        this.reload();
    }

    private final void reload() {
        this.chips += (long)this.reloadAmount;
        long l = this.reloadCount;
        this.reloadCount = l + 1L;
    }
}

