/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.CountingSystem;
import com.panopset.compat.Logz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0019H\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001bJ\u000e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0004J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0004H\u0002J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u001bJ\u0006\u0010,\u001a\u00020\u000bJ\b\u0010-\u001a\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001bH\u0002J\u0006\u0010/\u001a\u00020\u0019J\u0006\u00100\u001a\u00020\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000b0\u000b \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\u0006R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010+\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/panopset/blackjackEngine/CountingSystems;", "", "countingSystemsData", "Ljava/util/ArrayList;", "", "<init>", "(Ljava/util/ArrayList;)V", "getCountingSystemsData", "()Ljava/util/ArrayList;", "systemCatalog", "", "Lcom/panopset/blackjackEngine/CountingSystem;", "keys", "Ljava/util/SortedSet;", "kotlin.jvm.PlatformType", "Ljava/util/SortedSet;", "keyNames", "getKeyNames", "setKeyNames", "defaultKey", "getDefaultKey", "()Ljava/lang/String;", "setDefaultKey", "(Ljava/lang/String;)V", "populateKeyNames", "", "getTrueCount", "", "count", "blackjackCard", "Lcom/panopset/blackjackEngine/BlackjackCard;", "populate", "setSystemByName", "keyName", "setSystemByKeyNamePosition", "position", "updateByIndex", "i", "getKeyNamePosition", "findSelectionNbr", "key", "findSelectionKey", "selection", "selected", "findSelected", "pointOfNoReturn", "setCountingSystem", "resetCount", "reset", "blackjackEngine"})
public final class CountingSystems {
    @NotNull
    private final ArrayList<String> countingSystemsData;
    @NotNull
    private Map<String, CountingSystem> systemCatalog;
    private SortedSet<CountingSystem> keys;
    @NotNull
    private ArrayList<String> keyNames;
    @NotNull
    private String defaultKey;
    @Nullable
    private CountingSystem selected;

    public CountingSystems(@NotNull ArrayList<String> countingSystemsData) {
        Intrinsics.checkNotNullParameter(countingSystemsData, "countingSystemsData");
        this.countingSystemsData = countingSystemsData;
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        this.systemCatalog = sortedMap;
        this.keys = Collections.synchronizedSortedSet(new TreeSet());
        this.keyNames = new ArrayList();
        this.defaultKey = "";
        this.populate();
        this.populateKeyNames();
        this.selected = this.systemCatalog.get(this.defaultKey);
    }

    @NotNull
    public final ArrayList<String> getCountingSystemsData() {
        return this.countingSystemsData;
    }

    @NotNull
    public final ArrayList<String> getKeyNames() {
        return this.keyNames;
    }

    public final void setKeyNames(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.keyNames = arrayList;
    }

    @NotNull
    public final String getDefaultKey() {
        return this.defaultKey;
    }

    public final void setDefaultKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.defaultKey = string;
    }

    private final void populateKeyNames() {
        Iterator<Map.Entry<String, CountingSystem>> iterator2 = this.systemCatalog.entrySet().iterator();
        while (iterator2.hasNext()) {
            CountingSystem value = iterator2.next().getValue();
            this.keys.add(value);
        }
        for (CountingSystem cs : this.keys) {
            this.keyNames.add(cs.getName());
        }
    }

    public final int getTrueCount() {
        return this.findSelected().getCount();
    }

    public final void count(@NotNull BlackjackCard blackjackCard) {
        Intrinsics.checkNotNullParameter(blackjackCard, "blackjackCard");
        this.findSelected().count(blackjackCard);
    }

    private final void populate() {
        String firstKey = "";
        this.systemCatalog.clear();
        int index = 0;
        Iterator<String> iterator2 = this.countingSystemsData.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String dta;
            String s;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (s.length() <= 31 || StringsKt.indexOf$default((CharSequence)s, "#", 0, false, 6, null) == 0) continue;
            boolean isDefault = StringsKt.indexOf$default((CharSequence)s, "*", 0, false, 6, null) > -1;
            String string = s.substring(isDefault ? 31 : 30);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String key = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Intrinsics.checkNotNullExpressionValue(s.substring(0, 30), "substring(...)");
            if (((CharSequence)firstKey).length() == 0) {
                firstKey = key;
            }
            this.systemCatalog.put(key, new CountingSystem(key, dta, index++));
            if (!isDefault) continue;
            this.defaultKey = key;
        }
        if (((CharSequence)this.defaultKey).length() == 0) {
            this.defaultKey = firstKey;
        }
    }

    public final void setSystemByName(@NotNull String keyName) {
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.setCountingSystem(this.getKeyNamePosition(keyName));
    }

    public final void setSystemByKeyNamePosition(int position) {
        this.setCountingSystem(position);
    }

    public final void updateByIndex(int i) {
        this.setSystemByKeyNamePosition(i);
    }

    public final int getKeyNamePosition(@NotNull String keyName) {
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        return this.findSelectionNbr(keyName);
    }

    private final int findSelectionNbr(String key) {
        Iterator<Map.Entry<String, CountingSystem>> iterator2 = this.systemCatalog.entrySet().iterator();
        while (iterator2.hasNext()) {
            CountingSystem value = iterator2.next().getValue();
            if (!Intrinsics.areEqual(value.getName(), key)) continue;
            return value.getSelection();
        }
        return this.findSelectionNbr(this.defaultKey);
    }

    @NotNull
    public final String findSelectionKey(int selection) {
        Iterator<Map.Entry<String, CountingSystem>> iterator2 = this.systemCatalog.entrySet().iterator();
        while (iterator2.hasNext()) {
            CountingSystem value = iterator2.next().getValue();
            if (value.getSelection() != selection) continue;
            return value.getName();
        }
        return this.defaultKey;
    }

    @NotNull
    public final CountingSystem findSelected() {
        CountingSystem countingSystem;
        if (this.selected == null) {
            String foundKey = "";
            Iterator<String> iterator2 = this.systemCatalog.keySet().iterator();
            while (iterator2.hasNext()) {
                String key;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (Intrinsics.areEqual(key, this.defaultKey)) {
                    foundKey = key;
                    continue;
                }
                if (!Intrinsics.areEqual(key, "*" + this.defaultKey)) continue;
                foundKey = key;
            }
            if (StringsKt.indexOf$default((CharSequence)foundKey, "*", 0, false, 6, null) == 0) {
                String string = foundKey.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                foundKey = string;
            }
            if (((CharSequence)foundKey).length() == 0) {
                this.selected = this.pointOfNoReturn();
            } else {
                CountingSystem countingSystem2 = this.systemCatalog.get(foundKey);
                if (countingSystem2 == null) {
                    countingSystem2 = this.selected = this.pointOfNoReturn();
                }
            }
        }
        if ((countingSystem = this.selected) == null) {
            countingSystem = this.pointOfNoReturn();
        }
        return countingSystem;
    }

    private final CountingSystem pointOfNoReturn() {
        Logz.INSTANCE.errorMsg("Failed to load counting systems from resource cs.txt.");
        return new CountingSystem("Hi-Low", "+1 +1 +1 +1 +1  0  0  0 -1 -1 Hi-Lo", 4);
    }

    private final void setCountingSystem(int position) {
        this.selected = this.systemCatalog.get(this.findSelectionKey(position));
    }

    public final void resetCount() {
        this.findSelected().resetCount();
    }

    public final void reset() {
        this.populate();
        this.selected = this.systemCatalog.get(this.defaultKey);
        this.resetCount();
    }
}

