/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackGameEngine;
import com.panopset.blackjackEngine.Cycle;
import com.panopset.blackjackEngine.HandDealer;
import com.panopset.blackjackEngine.Player;
import com.panopset.blackjackEngine.Strategy;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/panopset/blackjackEngine/CycleController;", "", "g", "Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "<init>", "(Lcom/panopset/blackjackEngine/BlackjackGameEngine;)V", "getG", "()Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "cycle", "Lcom/panopset/blackjackEngine/Cycle;", "getCycle", "()Lcom/panopset/blackjackEngine/Cycle;", "setCycle", "(Lcom/panopset/blackjackEngine/Cycle;)V", "toString", "", "strategy", "Lcom/panopset/blackjackEngine/Strategy;", "reset", "", "cloneDealer", "Lcom/panopset/blackjackEngine/HandDealer;", "clonePlayers", "", "Lcom/panopset/blackjackEngine/Player;", "isDealt", "", "()Z", "isActive", "blackjackEngine"})
public final class CycleController {
    @NotNull
    private final BlackjackGameEngine g;
    @Nullable
    private Cycle cycle;

    public CycleController(@NotNull BlackjackGameEngine g) {
        Intrinsics.checkNotNullParameter(g, "g");
        this.g = g;
    }

    @NotNull
    public final BlackjackGameEngine getG() {
        return this.g;
    }

    @Nullable
    public final Cycle getCycle() {
        return this.cycle;
    }

    public final void setCycle(@Nullable Cycle cycle) {
        this.cycle = cycle;
    }

    @NotNull
    public String toString() {
        StringWriter sw = new StringWriter();
        sw.append("cycle:" + this.cycle);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final synchronized Cycle getCycle(@NotNull BlackjackGameEngine g, @NotNull Strategy strategy) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        if (this.cycle == null) {
            this.cycle = new Cycle(g, strategy);
        }
        Cycle cycle = this.cycle;
        Intrinsics.checkNotNull(cycle);
        return cycle;
    }

    public final synchronized void reset() {
        this.cycle = null;
    }

    @NotNull
    public final synchronized HandDealer cloneDealer() {
        Object object = this.cycle;
        if (object == null || (object = ((Cycle)object).getDealer()) == null) {
            object = new HandDealer();
        }
        return new HandDealer((HandDealer)object);
    }

    @NotNull
    public final synchronized List<Player> clonePlayers() {
        ArrayList<Player> clonedPlayers = new ArrayList<Player>();
        if (this.cycle == null) {
            return clonedPlayers;
        }
        Cycle cycle = this.cycle;
        Intrinsics.checkNotNull(cycle);
        Iterator<Player> iterator2 = cycle.getPlayers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Player player;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            clonedPlayers.add(new Player(player));
        }
        return clonedPlayers;
    }

    public final boolean isDealt() {
        boolean bl;
        if (this.cycle == null) {
            bl = false;
        } else {
            Cycle cycle = this.cycle;
            Intrinsics.checkNotNull(cycle);
            bl = cycle.isDealt();
        }
        return bl;
    }

    public final boolean isActive() {
        boolean bl;
        if (this.cycle == null) {
            bl = false;
        } else {
            Cycle cycle = this.cycle;
            Intrinsics.checkNotNull(cycle);
            bl = cycle.isActive();
        }
        return bl;
    }
}

