/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Wager;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/panopset/blackjackEngine/Player;", "", "wager", "Lcom/panopset/blackjackEngine/Wager;", "<init>", "(Lcom/panopset/blackjackEngine/Wager;)V", "player", "(Lcom/panopset/blackjackEngine/Player;)V", "getWager", "()Lcom/panopset/blackjackEngine/Wager;", "hands", "Ljava/util/ArrayList;", "Lcom/panopset/blackjackEngine/HandPlayer;", "Lkotlin/collections/ArrayList;", "getHands", "()Ljava/util/ArrayList;", "isSettled", "", "()Z", "setSettled", "(Z)V", "toString", "", "activeHand", "getActiveHand", "()Lcom/panopset/blackjackEngine/HandPlayer;", "isFinal", "blackjackEngine"})
public final class Player {
    @NotNull
    private final Wager wager;
    @NotNull
    private final ArrayList<HandPlayer> hands;
    private boolean isSettled;

    public Player(@NotNull Wager wager) {
        Intrinsics.checkNotNullParameter(wager, "wager");
        this.wager = wager;
        this.hands = new ArrayList();
        if (this.hands.isEmpty()) {
            this.hands.add(new HandPlayer(this.wager));
        }
    }

    @NotNull
    public final Wager getWager() {
        return this.wager;
    }

    public Player(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this(new Wager(player.wager));
        this.hands.clear();
        Iterator<HandPlayer> iterator2 = player.hands.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<HandPlayer> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            HandPlayer handPlayer;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            this.hands.add(new HandPlayer(handPlayer));
        }
    }

    @NotNull
    public final ArrayList<HandPlayer> getHands() {
        return this.hands;
    }

    public final boolean isSettled() {
        return this.isSettled;
    }

    public final void setSettled(boolean bl) {
        this.isSettled = bl;
    }

    @NotNull
    public String toString() {
        StringWriter sw = new StringWriter();
        Iterator iterator2 = ((Iterable)this.hands).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            HandPlayer h = (HandPlayer)iterator2.next();
            String string = "Player #%d: cards:%s value: %d ";
            Object[] objectArray = new Object[]{i, h.getBlackjackCards(), h.getHandValue()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            sw.append(string2);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Nullable
    public final synchronized HandPlayer getActiveHand() {
        Iterator<HandPlayer> iterator2 = this.hands.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<HandPlayer> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            HandPlayer h;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (h.isFinal()) continue;
            return h;
        }
        return null;
    }

    public final synchronized boolean isFinal() {
        return this.getActiveHand() == null;
    }
}

