/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u001d\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/panopset/compat/Numberop;", "", "<init>", "()V", "parseInt", "", "value", "", "parse", "base", "defaultValue", "(Ljava/lang/String;Ljava/lang/Integer;)I", "isNumber", "", "isInteger", "compat"})
public final class Numberop {
    @NotNull
    public static final Numberop INSTANCE = new Numberop();

    private Numberop() {
    }

    public final int parseInt(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Stringop.INSTANCE.isPopulated(value)) {
            return 0;
        }
        String str = StringsKt.replace$default(value, ",", "", false, 4, null);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException var3) {
            Logz.INSTANCE.errorMsg(value, (Throwable)var3);
            return 0;
        }
    }

    public final int parse(@NotNull String value, int base, int defaultValue) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Stringop.INSTANCE.isPopulated(value)) {
            return defaultValue;
        }
        String str = StringsKt.replace$default(value, ",", "", false, 4, null);
        try {
            return Integer.parseInt(str, CharsKt.checkRadix(base));
        }
        catch (NumberFormatException var4) {
            Logz.INSTANCE.errorEx(var4);
            return defaultValue;
        }
    }

    public final int parse(@NotNull String value, @Nullable Integer base) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Stringop.INSTANCE.isPopulated(value)) {
            return -1;
        }
        String str = StringsKt.replace$default(value, ",", "", false, 4, null);
        try {
            Integer n = base;
            Intrinsics.checkNotNull(n);
            return Integer.parseInt(str, CharsKt.checkRadix(n));
        }
        catch (NumberFormatException var4) {
            Logz.INSTANCE.errorEx(var4);
            return -1;
        }
    }

    public final boolean isNumber(@Nullable String value) {
        if (value == null) {
            return false;
        }
        CharSequence charSequence = value;
        return new Regex("[0-9]*").matches(charSequence);
    }

    public final boolean isInteger(@Nullable String value) {
        if (value == null) {
            return false;
        }
        CharSequence charSequence = value;
        return new Regex("-?\\d+").matches(charSequence);
    }
}

