/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.security;

import com.panopset.PanopsetBranding;
import com.panopset.compat.Logz;
import com.panopset.compat.TextProcessor;
import com.panopset.desk.security.Checksum;
import com.panopset.fxapp.ApplicationBranding;
import com.panopset.fxapp.ApplicationInfo;
import com.panopset.fxapp.BrandedApp;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactory;
import com.panopset.fxapp.PanFileOrDirSelectorPanel;
import com.panopset.marin.secure.checksums.ChecksumReport;
import com.panopset.marin.secure.checksums.ChecksumType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0002J&\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/panopset/desk/security/Checksum;", "Lcom/panopset/fxapp/BrandedApp;", "<init>", "()V", "createDynapane", "Ljavafx/scene/layout/Pane;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "createCsCheckBoxesHBox", "Ljavafx/scene/layout/HBox;", "csCheckBoxes", "Ljava/util/ArrayList;", "Ljavafx/scene/control/CheckBox;", "Lkotlin/collections/ArrayList;", "doProcess", "", "csOut", "Ljavafx/scene/control/TextArea;", "csFileSelect", "Lcom/panopset/fxapp/PanFileOrDirSelectorPanel;", "createReport", "types", "", "Lcom/panopset/marin/secure/checksums/ChecksumType;", "getSelectedTypes", "Companion", "desk"})
public final class Checksum
extends BrandedApp {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Checksum() {
        super(new ApplicationInfo(){

            @Override
            public ApplicationBranding getApplicationBranding() {
                return new PanopsetBranding();
            }

            @Override
            public String getApplicationDisplayName() {
                return "Checksum";
            }

            @Override
            public String getDescription() {
                return "Validate files with various checksums you might typically encounter.";
            }

            @Override
            public void updateVersionMessage(FxDoc fxDoc) {
                ApplicationInfo.DefaultImpls.updateVersionMessage(this, fxDoc);
            }
        });
    }

    @Override
    @NotNull
    public Pane createDynapane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        HBox csCheckBoxesHBox = new HBox();
        Ref.BooleanRef isAllOn = new Ref.BooleanRef();
        isAllOn.element = true;
        TextArea csOut = PanComponentFactory.INSTANCE.createPanTextArea(fxDoc);
        ArrayList<CheckBox> csCheckBoxes = new ArrayList<CheckBox>();
        for (ChecksumType cst : ChecksumType.getEntries()) {
            CheckBox cb = PanComponentFactory.INSTANCE.createPanCheckBox(fxDoc, "id_cb" + cst.name(), cst.name());
            cb.setId("cs_algbtn_" + cst.name());
            if (Intrinsics.areEqual("BYTES", cst.name())) {
                cb.setTooltip(new Tooltip("This is just the byte count for the file, not any kind of checksum."));
            }
            csCheckBoxesHBox.getChildren().add(cb);
            csCheckBoxes.add(cb);
        }
        PanFileOrDirSelectorPanel csFileSelect = new PanFileOrDirSelectorPanel(fxDoc, "csFileOrDirSelect");
        Button csChecksum = PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> Checksum.createDynapane$lambda$0(this, csOut, csFileSelect, csCheckBoxes), "_Checksum", true, "Run checkbox specified checksums on selected file.");
        Button csAll = PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> Checksum.createDynapane$lambda$1(csCheckBoxes, isAllOn), "_All", true, "Toggle select/deselect all checkboxes.");
        BorderPane b = this.createStandardMenubarBorderPane(fxDoc);
        BorderPane bp = new BorderPane();
        VBox topControls = new VBox();
        Node[] nodeArray = new Node[2];
        Node[] nodeArray2 = new Node[]{csChecksum, csAll, csFileSelect.getPane()};
        nodeArray[0] = PanComponentFactory.INSTANCE.createPanHBox(nodeArray2);
        nodeArray[1] = this.createCsCheckBoxesHBox(csCheckBoxes);
        topControls.getChildren().addAll((Node[])nodeArray);
        bp.setTop(topControls);
        bp.setCenter(PanComponentFactory.INSTANCE.createPanScrollPane(csOut));
        b.setCenter(bp);
        return b;
    }

    private final HBox createCsCheckBoxesHBox(ArrayList<CheckBox> csCheckBoxes) {
        HBox rtn2 = new HBox();
        Iterator<CheckBox> iterator2 = csCheckBoxes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<CheckBox> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CheckBox cb;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            rtn2.getChildren().add(cb);
        }
        return rtn2;
    }

    private final void doProcess(TextArea csOut, PanFileOrDirSelectorPanel csFileSelect, ArrayList<CheckBox> csCheckBoxes) {
        List<ChecksumType> types = this.getSelectedTypes(csCheckBoxes);
        if (types.isEmpty()) {
            Logz.INSTANCE.warn("Nothing selected.");
            csOut.setText("Nothing selected.");
            return;
        }
        Logz.INSTANCE.clear();
        csOut.setText("");
        this.createReport(types, csFileSelect, csOut);
    }

    private final void createReport(List<? extends ChecksumType> types, PanFileOrDirSelectorPanel csFileSelect, TextArea csOut) {
        new ChecksumReport(new TextProcessor(csOut){
            final /* synthetic */ TextArea $csOut;
            {
                this.$csOut = $csOut;
            }

            public void clear() {
                Platform.runLater(() -> createReport.1.clear$lambda$0(this.$csOut));
            }

            public void append(String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                Platform.runLater(() -> createReport.1.append$lambda$1(this.$csOut, value));
            }

            private static final void clear$lambda$0(TextArea $csOut) {
                $csOut.setText("");
            }

            private static final void append$lambda$1(TextArea $csOut, String $value) {
                $csOut.appendText($value);
            }
        }).generateReport(csFileSelect.createFile(), types);
    }

    private final List<ChecksumType> getSelectedTypes(ArrayList<CheckBox> csCheckBoxes) {
        List rtn2 = new ArrayList();
        Iterator<CheckBox> iterator2 = csCheckBoxes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<CheckBox> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ChecksumType cst;
            CheckBox cb;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!cb.isSelected() || (cst = ChecksumType.Companion.find(cb.getText())) == null) continue;
            rtn2.add(cst);
        }
        return rtn2;
    }

    private static final Unit createDynapane$lambda$0(Checksum this$0, TextArea $csOut, PanFileOrDirSelectorPanel $csFileSelect, ArrayList $csCheckBoxes) {
        this$0.doProcess($csOut, $csFileSelect, $csCheckBoxes);
        return Unit.INSTANCE;
    }

    private static final Unit createDynapane$lambda$1(ArrayList $csCheckBoxes, Ref.BooleanRef $isAllOn) {
        Iterator iterator2 = $csCheckBoxes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            CheckBox cb = (CheckBox)e;
            cb.setSelected($isAllOn.element);
        }
        $isAllOn.element = !$isAllOn.element;
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/desk/security/Checksum$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "desk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            new Checksum().go();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

