/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.panopset.desk.utilities.PlatformDownload;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/panopset/desk/utilities/PlatformDownloadCollection;", "", "platformDisplayOrder", "", "platformName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPlatformDisplayOrder", "()Ljava/lang/String;", "getPlatformName", "platformDownloads", "Ljava/util/SortedSet;", "Lcom/panopset/desk/utilities/PlatformDownload;", "getPlatformDownloads", "()Ljava/util/SortedSet;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "desk"})
final class PlatformDownloadCollection
implements Comparable<PlatformDownloadCollection> {
    @NotNull
    private final String platformDisplayOrder;
    @NotNull
    private final String platformName;
    @NotNull
    private final SortedSet<PlatformDownload> platformDownloads;

    public PlatformDownloadCollection(@NotNull String platformDisplayOrder, @NotNull String platformName) {
        Intrinsics.checkNotNullParameter(platformDisplayOrder, "platformDisplayOrder");
        Intrinsics.checkNotNullParameter(platformName, "platformName");
        this.platformDisplayOrder = platformDisplayOrder;
        this.platformName = platformName;
        SortedSet sortedSet = Collections.synchronizedSortedSet(new TreeSet());
        Intrinsics.checkNotNullExpressionValue(sortedSet, "synchronizedSortedSet(...)");
        this.platformDownloads = sortedSet;
    }

    @NotNull
    public final String getPlatformDisplayOrder() {
        return this.platformDisplayOrder;
    }

    @NotNull
    public final String getPlatformName() {
        return this.platformName;
    }

    @NotNull
    public final SortedSet<PlatformDownload> getPlatformDownloads() {
        return this.platformDownloads;
    }

    @Override
    public int compareTo(@NotNull PlatformDownloadCollection other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.platformDisplayOrder.compareTo(other.platformDisplayOrder);
    }

    @NotNull
    public final String component1() {
        return this.platformDisplayOrder;
    }

    @NotNull
    public final String component2() {
        return this.platformName;
    }

    @NotNull
    public final PlatformDownloadCollection copy(@NotNull String platformDisplayOrder, @NotNull String platformName) {
        Intrinsics.checkNotNullParameter(platformDisplayOrder, "platformDisplayOrder");
        Intrinsics.checkNotNullParameter(platformName, "platformName");
        return new PlatformDownloadCollection(platformDisplayOrder, platformName);
    }

    public static /* synthetic */ PlatformDownloadCollection copy$default(PlatformDownloadCollection platformDownloadCollection, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = platformDownloadCollection.platformDisplayOrder;
        }
        if ((n & 2) != 0) {
            string2 = platformDownloadCollection.platformName;
        }
        return platformDownloadCollection.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "PlatformDownloadCollection(platformDisplayOrder=" + this.platformDisplayOrder + ", platformName=" + this.platformName + ")";
    }

    public int hashCode() {
        int result = this.platformDisplayOrder.hashCode();
        result = result * 31 + this.platformName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformDownloadCollection)) {
            return false;
        }
        PlatformDownloadCollection platformDownloadCollection = (PlatformDownloadCollection)other;
        if (!Intrinsics.areEqual(this.platformDisplayOrder, platformDownloadCollection.platformDisplayOrder)) {
            return false;
        }
        return Intrinsics.areEqual(this.platformName, platformDownloadCollection.platformName);
    }
}

