/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.MapProvider;
import com.panopset.compat.NetworkInfo;
import com.panopset.compat.Nls;
import com.panopset.compat.Propop;
import com.panopset.compat.Rezop;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandFile;
import com.panopset.flywheel.Control;
import com.panopset.flywheel.FlywheelBuilder;
import com.panopset.flywheel.FlywheelHelp;
import com.panopset.flywheel.LineFeedRules;
import com.panopset.flywheel.LineFeedRulesKt;
import com.panopset.flywheel.MapHold;
import com.panopset.flywheel.ScriptSecurity;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateSource;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\r\u0018\u0000 m2\u00020\u0001:\u0001mB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020#J\u0016\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020#J\u001a\u0010@\u001a\u0002022\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0)J\u000e\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020#J\u0010\u0010D\u001a\u0002022\b\u0010\u000e\u001a\u0004\u0018\u00010#J\u0010\u0010E\u001a\u00020#2\u0006\u0010?\u001a\u00020#H\u0016J\u0006\u0010F\u001a\u00020#J\u0006\u0010G\u001a\u00020\rJ\u000e\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020#J\u0006\u0010L\u001a\u00020#J\u000e\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020#J\u0010\u0010]\u001a\u0002022\b\u0010\u000e\u001a\u0004\u0018\u00010#J\u0010\u0010^\u001a\u0002022\b\u0010\u000e\u001a\u0004\u0018\u00010#J\u0010\u0010_\u001a\u0002022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010d\u001a\u0002022\u0006\u0010\u000e\u001a\u00020#J\u0016\u0010e\u001a\u0002022\u0006\u0010f\u001a\u00020#2\u0006\u0010g\u001a\u00020#R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020*\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0004\u0018\u00010,8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b6\u00108R\u001a\u00109\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0014\u0010J\u001a\u000207X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00108R\u0010\u0010K\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010O\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bO\u00108R&\u0010P\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020*0QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u0011\u0010V\u001a\u00020W\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u001a\u0010Z\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u00108\"\u0004\b[\u0010\\R\u0017\u0010`\u001a\b\u0012\u0004\u0012\u00020#0a\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010cR\u001a\u0010h\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010l\u00a8\u0006n"}, d2={"Lcom/panopset/flywheel/Flywheel;", "Lcom/panopset/compat/MapProvider;", "sls", "Lcom/panopset/flywheel/TemplateSource;", "<init>", "(Lcom/panopset/flywheel/TemplateSource;)V", "getSls", "()Lcom/panopset/flywheel/TemplateSource;", "mapHold", "Lcom/panopset/flywheel/MapHold;", "getMapHold", "()Lcom/panopset/flywheel/MapHold;", "daTemplate", "Lcom/panopset/flywheel/Template;", "value", "Ljava/io/File;", "targetDirectory", "getTargetDirectory", "()Ljava/io/File;", "file", "resolvingCommand", "Lcom/panopset/flywheel/Command;", "getResolvingCommand", "()Lcom/panopset/flywheel/Command;", "pwriter", "Ljava/io/StringWriter;", "currentCommandFile", "Lcom/panopset/flywheel/CommandFile;", "getCurrentCommandFile", "()Lcom/panopset/flywheel/CommandFile;", "setCurrentCommandFile", "(Lcom/panopset/flywheel/CommandFile;)V", "replacements", "Ljava/util/ArrayList;", "", "", "getReplacements", "()Ljava/util/ArrayList;", "setReplacements", "(Ljava/util/ArrayList;)V", "registeredObjs", "", "", "lineFeedRules", "Lcom/panopset/flywheel/LineFeedRules;", "getLineFeedRules", "()Lcom/panopset/flywheel/LineFeedRules;", "setLineFeedRules", "(Lcom/panopset/flywheel/LineFeedRules;)V", "copyPackageResource", "", "template", "resourcePath", "targetPath", "isTargetDirectoryValid", "", "()Z", "writer", "getWriter", "()Ljava/io/StringWriter;", "setWriter", "(Ljava/io/StringWriter;)V", "put", "key", "mergeMap", "map", "loadProperties", "relativePath", "suppressReplacements", "getEntry", "exec", "getTemplate", "stop", "message", "isStopped", "baseDirectoryPath", "getBaseDirectoryPath", "getBaseRelativePath", "simpleFileName", "isReplacementsSuppressed", "registeredObjects", "Ljava/util/HashMap;", "getRegisteredObjects", "()Ljava/util/HashMap;", "setRegisteredObjects", "(Ljava/util/HashMap;)V", "control", "Lcom/panopset/flywheel/Control;", "getControl", "()Lcom/panopset/flywheel/Control;", "isOutputEnabled", "setOutputEnabled", "(Z)V", "setBaseDirectoryPath", "setTargetDirectory", "setFile", "findLines", "", "getFindLines", "()Ljava/util/List;", "setFindLine", "setFindLines", "v0", "v1", "combine", "getCombine", "()Ljava/lang/String;", "setCombine", "(Ljava/lang/String;)V", "Companion", "flywheel"})
public final class Flywheel
implements MapProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TemplateSource sls;
    @NotNull
    private final MapHold mapHold;
    @Nullable
    private Template daTemplate;
    @Nullable
    private File targetDirectory;
    @Nullable
    private File file;
    @Nullable
    private final Command resolvingCommand;
    @Nullable
    private StringWriter pwriter;
    @Nullable
    private CommandFile currentCommandFile;
    @NotNull
    private ArrayList<String[]> replacements;
    @Nullable
    private Map<String, Object> registeredObjs;
    @Nullable
    private LineFeedRules lineFeedRules;
    @NotNull
    private StringWriter writer;
    private final boolean isStopped;
    @Nullable
    private String baseDirectoryPath;
    @NotNull
    private HashMap<String, Object> registeredObjects;
    @NotNull
    private final Control control;
    private boolean isOutputEnabled;
    @NotNull
    private final List<String> findLines;
    @NotNull
    private String combine;

    public Flywheel(@Nullable TemplateSource sls) {
        this.sls = sls;
        this.mapHold = new MapHold();
        this.replacements = new ArrayList();
        this.writer = new StringWriter();
        this.registeredObjects = new HashMap();
        this.control = new Control();
        this.isOutputEnabled = true;
        this.findLines = new ArrayList();
        this.combine = "";
        ScriptSecurity.INSTANCE.defineAllowedScriptCalls();
        Object object = this.sls;
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        this.mapHold.put("com.panopset.flywheel.file", (String)object);
        this.mapHold.put("com.panopset.MACAddress", NetworkInfo.INSTANCE.getMaca());
    }

    @Nullable
    public final TemplateSource getSls() {
        return this.sls;
    }

    @NotNull
    public final MapHold getMapHold() {
        return this.mapHold;
    }

    @Nullable
    public final File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Nullable
    public final Command getResolvingCommand() {
        return this.resolvingCommand;
    }

    @Nullable
    public final CommandFile getCurrentCommandFile() {
        return this.currentCommandFile;
    }

    public final void setCurrentCommandFile(@Nullable CommandFile commandFile) {
        this.currentCommandFile = commandFile;
    }

    @NotNull
    public final ArrayList<String[]> getReplacements() {
        return this.replacements;
    }

    public final void setReplacements(@NotNull ArrayList<String[]> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.replacements = arrayList;
    }

    @Nullable
    public final LineFeedRules getLineFeedRules() {
        if (this.lineFeedRules == null) {
            this.lineFeedRules = LineFeedRulesKt.getFULL_BREAKS();
        }
        return this.lineFeedRules;
    }

    public final void setLineFeedRules(@Nullable LineFeedRules lineFeedRules) {
        this.lineFeedRules = lineFeedRules;
    }

    public final void copyPackageResource(@NotNull Template template, @NotNull String resourcePath, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(targetPath, "targetPath");
        try {
            if (this.targetDirectory == null) {
                return;
            }
            Class<?> clazz = this.getClass();
            File file = this.targetDirectory;
            Intrinsics.checkNotNull(file);
            Rezop.INSTANCE.copyTextResourceToFile(clazz, resourcePath, Fileop.INSTANCE.getCanonicalPath(file) + "/" + targetPath);
        }
        catch (IOException ex) {
            StringWriter sw = new StringWriter();
            sw.append("baseDirectoryPath: " + this.baseDirectoryPath);
            sw.append(Stringop.INSTANCE.getEol());
            File file = this.file;
            Intrinsics.checkNotNull(file);
            sw.append("Template file: " + Fileop.INSTANCE.getCanonicalPath(file));
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("targetDirectory: " + this.targetDirectory);
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("resourcePath: " + resourcePath);
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("targetPath: " + targetPath);
            sw.append(Stringop.INSTANCE.getEol());
            template.getTemplateSource();
            sw.append("executing from: " + template.getTemplateSource().getName());
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("Line: ");
            sw.append("" + template.getTemplateSource().getLine());
            sw.append(Stringop.INSTANCE.getEol());
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            Logz.INSTANCE.warn(string);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTargetDirectoryValid() {
        if (this.targetDirectory != null) {
            File file = this.targetDirectory;
            Intrinsics.checkNotNull(file);
            if (!file.exists()) {
                File file2 = this.targetDirectory;
                Intrinsics.checkNotNull(file2);
                Fileop.INSTANCE.mkdirs(file2);
            }
        }
        if (this.targetDirectory == null) return false;
        File file = this.targetDirectory;
        Intrinsics.checkNotNull(file);
        if (!file.isDirectory()) return false;
        File file3 = this.targetDirectory;
        Intrinsics.checkNotNull(file3);
        if (!file3.exists()) return false;
        File file4 = this.targetDirectory;
        Intrinsics.checkNotNull(file4);
        if (!file4.canWrite()) return false;
        return true;
    }

    @NotNull
    public final StringWriter getWriter() {
        return this.writer;
    }

    public final void setWriter(@NotNull StringWriter stringWriter) {
        Intrinsics.checkNotNullParameter(stringWriter, "<set-?>");
        this.writer = stringWriter;
    }

    public final void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.mapHold.put(key, value);
    }

    public final void mergeMap(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        this.mapHold.mergeMap(map);
    }

    @NotNull
    public final String loadProperties(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        File file = new File(this.getBaseDirectoryPath() + "/" + relativePath);
        Properties props = new Properties();
        if (!file.exists()) {
            try {
                Rezop.INSTANCE.copyTextResourceToFile(this.getClass(), relativePath, file);
            }
            catch (IOException ex) {
                Logz.INSTANCE.warn("relativePath: " + relativePath);
                Logz.INSTANCE.errorEx(ex);
            }
        }
        Propop.INSTANCE.load(props, file);
        for (Object k : props.keySet()) {
            String string = k.toString();
            String string2 = props.getProperty(k.toString());
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
            this.put(string, string2);
        }
        return "";
    }

    public final void suppressReplacements(@Nullable String value) {
        if (value == null) {
            this.control.setReplacementsSuppressed(false);
            return;
        }
        this.control.setReplacementsSuppressed(Boolean.parseBoolean(value));
    }

    @Override
    @NotNull
    public String getEntry(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.mapHold.get(key);
    }

    @NotNull
    public final String exec() {
        if (this.isStopped) {
            return "";
        }
        this.getTemplate().output();
        String string = this.writer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Template getTemplate() {
        if (this.daTemplate == null) {
            TemplateSource templateSource = this.sls;
            Intrinsics.checkNotNull(templateSource);
            LineFeedRules lineFeedRules = this.getLineFeedRules();
            Intrinsics.checkNotNull(lineFeedRules);
            this.daTemplate = new Template(this, templateSource, lineFeedRules);
        }
        Template template = this.daTemplate;
        Intrinsics.checkNotNull(template, "null cannot be cast to non-null type com.panopset.flywheel.Template");
        return template;
    }

    public final void stop(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Logz.INSTANCE.errorMsg(message);
        if (this.resolvingCommand != null) {
            Logz.INSTANCE.warn(Nls.INSTANCE.xlate("Stopped while executing line") + " " + this.resolvingCommand);
            Logz.INSTANCE.debug(" at: " + this.resolvingCommand);
        }
        Logz.INSTANCE.debug(this.mapHold.dump());
        Logz.INSTANCE.warn(Nls.INSTANCE.xlate("Template parsing stopped.  Check debug in help->Show log, for more information"));
        this.control.stop(message);
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getBaseDirectoryPath() {
        block5: {
            if (this.baseDirectoryPath != null) break block5;
            v0 = this;
            if (this.file == null) ** GOTO lbl-1000
            v1 = this.file;
            Intrinsics.checkNotNull(v1);
            if (v1.exists()) {
                var3_1 = v0;
                try {
                    v0 = var3_1;
                    v2 = this.file;
                    Intrinsics.checkNotNull(v2);
                    var1_2 = v2.getParentFile().getCanonicalPath();
                }
                catch (IOException e) {
                    v3 = var3_1;
                    Logz.INSTANCE.errorEx(e);
                    return "";
                }
                v4 = var1_2;
            } else lbl-1000:
            // 2 sources

            {
                v4 = v0.baseDirectoryPath = System.getProperty("user.home");
            }
        }
        if ((v5 = this.baseDirectoryPath) == null) {
            v5 = "";
        }
        return v5;
    }

    @NotNull
    public final String getBaseRelativePath(@NotNull String simpleFileName) {
        Intrinsics.checkNotNullParameter(simpleFileName, "simpleFileName");
        return this.getBaseDirectoryPath() + "/" + simpleFileName;
    }

    public final boolean isReplacementsSuppressed() {
        return this.control.isReplacementsSuppressed();
    }

    @NotNull
    public final HashMap<String, Object> getRegisteredObjects() {
        return this.registeredObjects;
    }

    public final void setRegisteredObjects(@NotNull HashMap<String, Object> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.registeredObjects = hashMap;
    }

    @NotNull
    public final Control getControl() {
        return this.control;
    }

    public final boolean isOutputEnabled() {
        return this.isOutputEnabled;
    }

    public final void setOutputEnabled(boolean bl) {
        this.isOutputEnabled = bl;
    }

    public final void setBaseDirectoryPath(@Nullable String value) {
        if (value != null) {
            this.baseDirectoryPath = value;
        }
        if (this.file != null && this.baseDirectoryPath == null) {
            File file = this.file;
            Intrinsics.checkNotNull(file);
            this.baseDirectoryPath = Fileop.INSTANCE.getParentDirectory(file);
        }
    }

    public final void setTargetDirectory(@Nullable String value) {
        if (Stringop.INSTANCE.isPopulated(value)) {
            this.targetDirectory = new File(value);
        }
        if (this.targetDirectory == null) {
            this.targetDirectory = this.targetDirectory;
        }
    }

    public final void setFile(@Nullable File value) {
        if (value != null) {
            File file = this.file = value;
            Intrinsics.checkNotNull(file);
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.mapHold.put("com.panopset.flywheel.template", string);
        }
    }

    @NotNull
    public final List<String> getFindLines() {
        return this.findLines;
    }

    public final void setFindLine(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.findLines.clear();
        this.findLines.add(value);
    }

    public final void setFindLines(@NotNull String v0, @NotNull String v1) {
        Intrinsics.checkNotNullParameter(v0, "v0");
        Intrinsics.checkNotNullParameter(v1, "v1");
        this.findLines.clear();
        this.findLines.add(v0);
        this.findLines.add(v1);
    }

    @NotNull
    public final String getCombine() {
        return this.combine;
    }

    public final void setCombine(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.combine = string;
    }

    @JvmStatic
    public static final void main(String ... args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/flywheel/Flywheel$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "flywheel"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(String ... args) {
            Intrinsics.checkNotNullParameter(args, "args");
            if (args.length == 0 || args.length > 2) {
                Logz.INSTANCE.dspmsg("Params are script and target directory, or\nfw (properties file)\nor\nfw --help");
            } else if (args.length == 1) {
                if (Intrinsics.areEqual("--help", args[0])) {
                    FlywheelHelp.INSTANCE.outputHelp();
                } else {
                    new FlywheelBuilder().properties(new File(args[0])).construct().exec();
                }
            } else {
                String scriptFileName = args[0];
                String targetDirectoryName = args[1];
                File scriptFile = new File(scriptFileName);
                File targetDirectory = new File(targetDirectoryName);
                if (!scriptFile.exists()) {
                    Logz.INSTANCE.errorMsg("File does not exist.", scriptFile);
                    return;
                }
                if (!scriptFile.canRead()) {
                    Logz.INSTANCE.errorMsg("Can not read.", scriptFile);
                    return;
                }
                String string = "%s:%s";
                Object[] objectArray = new Object[]{"Script file", Fileop.INSTANCE.getCanonicalPath(scriptFile)};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                Logz.INSTANCE.info(string2);
                string = "%s:%s";
                objectArray = new Object[]{"Target directory", Fileop.INSTANCE.getCanonicalPath(targetDirectory)};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                Logz.INSTANCE.info(string3);
                new FlywheelBuilder().file(scriptFile).targetDirectory(targetDirectory).construct().exec();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

