/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Stringop;
import com.panopset.flywheel.FlywheelHelp;
import com.panopset.flywheel.Javop;
import com.panopset.flywheel.NamedMap;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0007J\u001a\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0014J\u0006\u0010\u0015\u001a\u00020\u000bJ$\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aH\u0002R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/panopset/flywheel/MapHold;", "", "<init>", "()V", "mapStack", "Ljava/util/Stack;", "Lcom/panopset/flywheel/NamedMap;", "", "getMapStack", "()Ljava/util/Stack;", "pushNewMapStack", "", "mapStackName", "put", "key", "value", "get", "dump", "mergeMap", "map", "", "outputVariablesForHelp", "outputNamedMap", "title", "namedMap", "outputMap", "", "flywheel"})
public final class MapHold {
    @NotNull
    private final Stack<NamedMap<String, String>> mapStack = new Stack();

    public MapHold() {
        this.pushNewMapStack(Stringop.INSTANCE.getNextJvmUniqueIDstr());
    }

    @NotNull
    public final Stack<NamedMap<String, String>> getMapStack() {
        return this.mapStack;
    }

    public final void pushNewMapStack(@NotNull String mapStackName) {
        Intrinsics.checkNotNullParameter(mapStackName, "mapStackName");
        this.mapStack.push(new NamedMap(mapStackName, null, 2, null));
    }

    public final void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.mapStack.peek().put(key, value);
    }

    @NotNull
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (this.mapStack.isEmpty()) {
            throw new RuntimeException("mapStack empty, this should be an impossible condition.");
        }
        Stack<NamedMap> stack = new Stack<NamedMap>();
        Iterator iterator2 = this.mapStack.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            NamedMap item = (NamedMap)iterator3.next();
            stack.push(item);
        }
        while (!stack.isEmpty()) {
            NamedMap nm = (NamedMap)stack.pop();
            String rtn2 = (String)nm.get(key);
            if (rtn2 == null) continue;
            return rtn2;
        }
        if (Stringop.INSTANCE.isPopulated(key)) {
            String string;
            String rtn3 = System.getProperty(key);
            if (Stringop.INSTANCE.isPopulated(rtn3)) {
                string = rtn3;
                Intrinsics.checkNotNull(string);
                return string;
            }
            rtn3 = System.getenv(key);
            if (Stringop.INSTANCE.isPopulated(rtn3)) {
                string = rtn3;
                Intrinsics.checkNotNull(string);
                return string;
            }
        }
        return "";
    }

    @NotNull
    public final String dump() {
        return Javop.INSTANCE.dump(this.mapStack.peek().getMap());
    }

    public final void mergeMap(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        this.mapStack.push(new NamedMap<String, String>(Stringop.INSTANCE.getNextJvmUniqueIDstr(), map));
    }

    public final void outputVariablesForHelp() {
        FlywheelHelp.INSTANCE.getC().line80("");
        Iterator iterator2 = ((Iterable)this.mapStack).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            NamedMap namedMap = (NamedMap)iterator2.next();
            String string = "Level " + i + " Variables";
            Intrinsics.checkNotNull(namedMap);
            this.outputNamedMap(string, namedMap);
        }
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue(properties, "getProperties(...)");
        this.outputMap("System properties, also available as Flywheel variables", MapsKt.toSortedMap(properties, new Comparator(){

            public final int compare(T a, T b) {
                T it = a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.toString());
                it = b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.toString()));
            }
        }));
        SortedMap envMap = Collections.synchronizedSortedMap(new TreeMap());
        for (String key : System.getenv().keySet()) {
            Intrinsics.checkNotNull(envMap);
            Map map = envMap;
            String string = System.getenv().get(key);
            if (string == null) {
                string = "";
            }
            String string2 = string;
            map.put(key, string2);
        }
        Intrinsics.checkNotNull(envMap);
        this.outputMap("Environment variables, also available as Flywheel variables", MapsKt.toSortedMap(envMap));
    }

    private final void outputNamedMap(String title, NamedMap<String, String> namedMap) {
        this.outputMap(title, (Map)MapsKt.toSortedMap(namedMap.getMap()));
    }

    private final void outputMap(String title, Map<?, ?> map) {
        FlywheelHelp.INSTANCE.getC().line80();
        FlywheelHelp.INSTANCE.getC().centerHeader(title);
        FlywheelHelp.INSTANCE.getC().line80();
        FlywheelHelp.INSTANCE.getC().line80("");
        StringWriter sw = new StringWriter();
        boolean firstTime = true;
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (firstTime) {
                firstTime = false;
            } else {
                sw.append("\n");
            }
            sw.append(String.valueOf(e.getKey()));
            sw.append("=");
            sw.append(String.valueOf(e.getValue()));
        }
        System.out.println((Object)sw.toString());
        FlywheelHelp.INSTANCE.getC().line80("");
    }
}

