/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.GlobalPropertiesKt;
import com.panopset.compat.Logz;
import com.panopset.fxapp.FontSize;
import com.panopset.fxapp.FxDoc;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020\u000bJ\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020%J\u0016\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0015J\u0016\u0010\b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.\u00a8\u00063"}, d2={"Lcom/panopset/fxapp/FontManagerFX;", "", "<init>", "()V", "fontSize", "Lcom/panopset/fxapp/FontSize;", "getFontSize", "()Lcom/panopset/fxapp/FontSize;", "setFontSize", "(Lcom/panopset/fxapp/FontSize;)V", "monospace", "Ljavafx/scene/text/Font;", "boldArial", "plainArial", "boldSerif", "plainSerif", "borderTitle", "getCurrentFontSizeName", "", "getMonoStyle", "i", "", "getCurrentBaseStyle", "updateAllFontSizes", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "getMonospace", "getBoldArial", "getBoldSerif", "getPlainArial", "getPlainSerif", "getBorderTitle", "register", "control", "Ljavafx/scene/Node;", "registerTab", "Ljavafx/scene/control/Tab;", "tab", "registerMenubar", "menuBar", "Ljavafx/scene/control/MenuBar;", "getSize", "imgRatio", "", "getImgRatio", "()D", "svgRatio", "getSvgRatio", "getStyleFor", "fontSizeValue", "fxapp"})
public final class FontManagerFX {
    @NotNull
    public static final FontManagerFX INSTANCE;
    @NotNull
    private static FontSize fontSize;
    @NotNull
    private static Font monospace;
    @NotNull
    private static Font boldArial;
    @NotNull
    private static Font plainArial;
    @NotNull
    private static Font boldSerif;
    @NotNull
    private static Font plainSerif;
    @NotNull
    private static Font borderTitle;
    private static final double imgRatio;
    private static final double svgRatio;

    private FontManagerFX() {
    }

    @NotNull
    public final FontSize getFontSize() {
        return fontSize;
    }

    public final void setFontSize(@NotNull FontSize fontSize) {
        Intrinsics.checkNotNullParameter((Object)fontSize, "<set-?>");
        FontManagerFX.fontSize = fontSize;
    }

    @NotNull
    public final String getCurrentFontSizeName() {
        return fontSize.name();
    }

    private final String getMonoStyle(int i) {
        String string = "-fx-font-size: %dpx; -fx-font-family: 'monospaced';";
        Object[] objectArray = new Object[]{i};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String getCurrentBaseStyle() {
        return this.getStyleFor(fontSize.getValue());
    }

    public final void updateAllFontSizes(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        String style = this.getStyleFor(fontSize.getValue());
        String stylem = this.getMonoStyle(fontSize.getValue());
        for (MenuBar mb : fxDoc.getMbs()) {
            mb.setStyle(style);
        }
        for (Node node : fxDoc.getNodes()) {
            if (node instanceof TextInputControl) {
                if (Intrinsics.areEqual("menubarStatusMessage", ((TextInputControl)node).getId())) {
                    Platform.runLater(() -> FontManagerFX.updateAllFontSizes$lambda$0(fxDoc));
                    continue;
                }
                ((TextInputControl)node).setStyle(stylem);
                continue;
            }
            node.setStyle(style);
        }
        for (TabPane tabPane : fxDoc.getTabPanes()) {
            tabPane.setStyle(style);
        }
        for (Tab tab : fxDoc.getTabs()) {
            tab.setStyle(style);
        }
        String string = "%d";
        Object[] objectArray = new Object[]{fontSize.getValue()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        GlobalPropertiesKt.globalPropsPut("fontsize", string2);
        monospace = new Font("Monospace", fontSize.getValue());
        boldArial = Font.font("Arial", FontWeight.BOLD, (double)fontSize.getValue());
        plainArial = new Font("Arial", fontSize.getValue());
        boldSerif = Font.font("Serif", FontWeight.BOLD, (double)fontSize.getValue());
        plainSerif = new Font("Serif", fontSize.getValue());
        borderTitle = Font.font("Arial", FontPosture.ITALIC, (double)fontSize.getValue());
    }

    @NotNull
    public final Font getMonospace() {
        return monospace;
    }

    @NotNull
    public final Font getBoldArial() {
        return boldArial;
    }

    @NotNull
    public final Font getBoldSerif() {
        return boldSerif;
    }

    @NotNull
    public final Font getPlainArial() {
        return plainArial;
    }

    @NotNull
    public final Font getPlainSerif() {
        return plainSerif;
    }

    @NotNull
    public final Font getBorderTitle() {
        return borderTitle;
    }

    public final void register(@NotNull FxDoc fxDoc, @NotNull Node control) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(control, "control");
        if (!fxDoc.getNodes().contains(control)) {
            fxDoc.getNodes().add(control);
            if (control instanceof TextInputControl) {
                ((TextInputControl)control).setStyle(this.getMonoStyle(fontSize.getValue()));
            } else {
                control.setStyle(this.getStyleFor(fontSize.getValue()));
            }
        }
    }

    @NotNull
    public final Tab registerTab(@NotNull FxDoc fxDoc, @NotNull Tab tab) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(tab, "tab");
        if (fxDoc.getTabs().contains(tab)) {
            Logz.INSTANCE.debug("Ignoring duplicate FontManagerFX registration of tab " + tab.getId());
        } else {
            fxDoc.getTabs().add(tab);
        }
        return tab;
    }

    public final void registerMenubar(@NotNull FxDoc fxDoc, @NotNull MenuBar menuBar) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(menuBar, "menuBar");
        if (fxDoc.getMbs().contains(menuBar)) {
            Logz.INSTANCE.debug("Ignoring duplicate FontManagerFX registration of menubar " + menuBar.getId());
        } else {
            fxDoc.getMbs().add(menuBar);
        }
    }

    public final int getSize() {
        return fontSize.getValue();
    }

    public final void setFontSize(@NotNull FxDoc fxDoc, @NotNull FontSize fontSize) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter((Object)fontSize, "fontSize");
        FontManagerFX.fontSize = fontSize;
        this.updateAllFontSizes(fxDoc);
    }

    public final double getImgRatio() {
        return imgRatio;
    }

    public final double getSvgRatio() {
        return svgRatio;
    }

    @NotNull
    public final String getStyleFor(int fontSizeValue) {
        String string = "-fx-font-size: %dpx";
        Object[] objectArray = new Object[]{fontSizeValue};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final void updateAllFontSizes$lambda$0(FxDoc $fxDoc) {
        $fxDoc.getFxDocMessage().refresh();
    }

    static {
        FontSize fontSize;
        INSTANCE = new FontManagerFX();
        FontManagerFX.fontSize = FontSize.Companion.getDEFAULT_SIZE();
        monospace = new Font("Monospace", FontManagerFX.fontSize.getValue());
        Font font = Font.font("Arial", FontWeight.BOLD, (double)FontManagerFX.fontSize.getValue());
        Intrinsics.checkNotNullExpressionValue(font, "font(...)");
        boldArial = font;
        plainArial = new Font("Arial", FontManagerFX.fontSize.getValue());
        Font font2 = Font.font("Serif", FontWeight.BOLD, (double)FontManagerFX.fontSize.getValue());
        Intrinsics.checkNotNullExpressionValue(font2, "font(...)");
        boldSerif = font2;
        plainSerif = new Font("Serif", FontManagerFX.fontSize.getValue());
        Font font3 = Font.font("Arial", FontPosture.ITALIC, (double)FontManagerFX.fontSize.getValue());
        Intrinsics.checkNotNullExpressionValue(font3, "font(...)");
        borderTitle = font3;
        try {
            String savedFontSizeValue = StringsKt.replace$default(GlobalPropertiesKt.globalPropsGet("fontsize"), "\"", "", false, 4, null);
            if (((CharSequence)savedFontSizeValue).length() == 0) {
                FontSize.Companion.getDEFAULT_SIZE();
            }
            fontSize = FontSize.Companion.findFromValue(savedFontSizeValue);
        }
        catch (NumberFormatException ex) {
            Logz.INSTANCE.errorEx(ex);
            fontSize = FontSize.Companion.getDEFAULT_SIZE();
        }
        FontManagerFX.fontSize = fontSize;
        imgRatio = FontManagerFX.fontSize.getImgRatio();
        svgRatio = FontManagerFX.fontSize.getSvgRatio();
    }
}

