/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.bootstrap;

import com.panopset.compat.AppVersion;
import com.panopset.compat.Stringop;
import com.panopset.compat.Trinary;
import com.panopset.compat.UrlHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/panopset/marin/bootstrap/VersionHelper;", "", "<init>", "()V", "OFFLINE", "", "availVers", "getAvailableVersion", "isReadyToUpdate", "Lcom/panopset/compat/Trinary;", "desk"})
public final class VersionHelper {
    @NotNull
    public static final VersionHelper INSTANCE = new VersionHelper();
    @NotNull
    private static final String OFFLINE = "Offline";
    @NotNull
    private static String availVers = "";

    private VersionHelper() {
    }

    @NotNull
    public final String getAvailableVersion() {
        if (((CharSequence)availVers).length() == 0) {
            String string;
            String panURL = "https://panopset.com";
            String versJson = UrlHelper.INSTANCE.getTextFromURL(panURL + "/version.json");
            if (Stringop.INSTANCE.isBlank(versJson)) {
                string = OFFLINE;
            } else {
                CharSequence charSequence = versJson;
                Regex regex = new Regex("\"");
                String string2 = "";
                charSequence = regex.replace(charSequence, string2);
                regex = new Regex("\n");
                string2 = "";
                charSequence = regex.replace(charSequence, string2);
                regex = new Regex("\r");
                string2 = "";
                string = regex.replace(charSequence, string2);
            }
            availVers = string;
        }
        return availVers;
    }

    @NotNull
    public final Trinary isReadyToUpdate() {
        Trinary trinary;
        String thisVersion = AppVersion.INSTANCE.getVersion();
        String availVersion = this.getAvailableVersion();
        if (Intrinsics.areEqual(OFFLINE, availVersion)) {
            return Trinary.ERROR;
        }
        if (Intrinsics.areEqual(availVersion, thisVersion)) {
            trinary = Trinary.FALSE;
        } else {
            if (availVersion.length() == thisVersion.length()) {
                int i = 0;
                int n = thisVersion.length();
                for (int j = 0; j < n; ++j) {
                    String availVersionLastChar;
                    char c = thisVersion.charAt(j);
                    if (++i != thisVersion.length()) continue;
                    int thisVersionLastNumber = Integer.parseInt(String.valueOf(c));
                    Intrinsics.checkNotNullExpressionValue(availVersion.substring(availVersion.length() - 1, availVersion.length()), "substring(...)");
                    int availVersionLastNumber = Integer.parseInt(availVersionLastChar);
                    if (availVersionLastNumber + 1 != thisVersionLastNumber) continue;
                    return Trinary.IMPOSSIBLE;
                }
            }
            trinary = Trinary.TRUE;
        }
        return trinary;
    }
}

