/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.games.blackjack;

import com.panopset.blackjackEngine.BlackjackGameEngine;
import com.panopset.blackjackEngine.BlackjackGameState;
import com.panopset.compat.Zombie;
import com.panopset.desk.games.bj.BlackjackFxControls;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.marin.games.blackjack.FeltPainter;
import java.util.Date;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010(\u001a\u00020\u0018H\u0002J\b\u0010)\u001a\u00020\u0015H\u0002J\u0006\u0010*\u001a\u00020\u0018J\b\u0010/\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010$\"\u0004\b.\u0010&\u00a8\u00060"}, d2={"Lcom/panopset/marin/games/blackjack/BlackjackGameController;", "", "ctls", "Lcom/panopset/desk/games/bj/BlackjackFxControls;", "bge", "Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "<init>", "(Lcom/panopset/desk/games/bj/BlackjackFxControls;Lcom/panopset/blackjackEngine/BlackjackGameEngine;)V", "getBge", "()Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "felt", "Ljavafx/scene/canvas/Canvas;", "getFelt", "()Ljavafx/scene/canvas/Canvas;", "setFelt", "(Ljavafx/scene/canvas/Canvas;)V", "dirty", "", "firstTime", "handleKey", "", "keyEvent", "Ljavafx/scene/input/KeyEvent;", "fontSize", "", "paintedSnapshot", "Lcom/panopset/blackjackEngine/BlackjackGameState;", "timer", "Ljavafx/animation/AnimationTimer;", "lastUpdate", "", "getLastUpdate", "()J", "setLastUpdate", "(J)V", "lastDirtyCheck", "startPaintCycle", "isDirty", "update", "binding", "dbgcount", "getDbgcount", "setDbgcount", "paintFelt", "desk"})
public final class BlackjackGameController {
    @NotNull
    private final BlackjackGameEngine bge;
    @NotNull
    private final FxDoc fxDoc;
    @NotNull
    private Canvas felt;
    private boolean dirty;
    private boolean firstTime;
    private int fontSize;
    @Nullable
    private BlackjackGameState paintedSnapshot;
    @NotNull
    private AnimationTimer timer;
    private long lastUpdate;
    private long lastDirtyCheck;
    private boolean binding;
    private long dbgcount;

    public BlackjackGameController(@NotNull BlackjackFxControls ctls, @NotNull BlackjackGameEngine bge) {
        Intrinsics.checkNotNullParameter(ctls, "ctls");
        Intrinsics.checkNotNullParameter(bge, "bge");
        this.bge = bge;
        this.fxDoc = ctls.getFxDoc();
        this.felt = ctls.getFelt();
        this.firstTime = true;
        Zombie.INSTANCE.addStopAction(() -> BlackjackGameController._init_$lambda$0(this));
        if (this.bge.getBankroll().getReloadAmount() == 0) {
            this.bge.frontEndPreInitCheck();
        }
        this.startPaintCycle();
        this.timer = new AnimationTimer(this){
            final /* synthetic */ BlackjackGameController this$0;
            {
                this.this$0 = $receiver;
            }

            public void handle(long now) {
                if (now - this.this$0.getLastUpdate() > 5000000L) {
                    BlackjackGameController.access$paintFelt(this.this$0);
                    this.this$0.setLastUpdate(now);
                }
            }
        };
    }

    @NotNull
    public final BlackjackGameEngine getBge() {
        return this.bge;
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final Canvas getFelt() {
        return this.felt;
    }

    public final void setFelt(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter(canvas, "<set-?>");
        this.felt = canvas;
    }

    private final void handleKey(KeyEvent keyEvent) {
        String string = keyEvent.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String action = string3;
        if (this.bge.isAutomaticRunning() && !Intrinsics.areEqual(action, "t")) {
            this.bge.exec("t");
            return;
        }
        this.bge.exec(action);
        this.lastUpdate = 0L;
        this.dirty = true;
    }

    public final long getLastUpdate() {
        return this.lastUpdate;
    }

    public final void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    private final void startPaintCycle() {
        Platform.runLater(() -> BlackjackGameController.startPaintCycle$lambda$1(this));
    }

    private final boolean isDirty() {
        long currentTime;
        if (this.fontSize != FontManagerFX.INSTANCE.getSize()) {
            this.fontSize = FontManagerFX.INSTANCE.getSize();
            this.dirty = true;
        }
        if (!this.dirty && (currentTime = new Date().getTime()) - this.lastDirtyCheck > 1000L) {
            this.lastDirtyCheck = currentTime;
            this.dirty = true;
        }
        return this.dirty;
    }

    public final void update() {
        this.dirty = true;
    }

    public final long getDbgcount() {
        return this.dbgcount;
    }

    public final void setDbgcount(long l) {
        this.dbgcount = l;
    }

    private final void paintFelt() {
        if (this.binding) {
            return;
        }
        if (this.felt.getParent() == null) {
            return;
        }
        int layoutHeight = (int)this.felt.getParent().getLayoutBounds().getHeight();
        int layoutWidth = (int)this.felt.getParent().getLayoutBounds().getWidth();
        if (layoutHeight < 10 || layoutWidth < 10) {
            return;
        }
        this.felt.setWidth(layoutWidth);
        this.felt.setHeight(layoutHeight);
        GraphicsContext g = this.felt.getGraphicsContext2D();
        if (!Zombie.INSTANCE.isActive()) {
            g.setFill(Color.DARKRED);
            g.fillRect(0.0, 0.0, layoutWidth, layoutHeight);
            return;
        }
        if (this.isDirty()) {
            if (this.firstTime) {
                this.firstTime = false;
                this.felt.getScene().setOnKeyPressed(arg_0 -> BlackjackGameController.paintFelt$lambda$2(this, arg_0));
                ThreadsKt.thread$default(false, false, null, null, 0, () -> BlackjackGameController.paintFelt$lambda$3(this), 31, null);
            }
        } else if (!this.bge.isAutomaticRunning()) {
            return;
        }
        FeltPainter feltPainter = new FeltPainter();
        BlackjackGameState blackjackGameState = this.bge.getLatestSnapshot();
        Intrinsics.checkNotNull(g);
        feltPainter.draw(blackjackGameState, g, layoutWidth, layoutHeight);
        if (feltPainter.getDbg()) {
            long l = this.dbgcount;
            this.dbgcount = l + 1L;
            g.fillText("diags " + l, 100.0, 100.0);
        }
        this.dirty = false;
    }

    private static final void _init_$lambda$0(BlackjackGameController this$0) {
        this$0.timer.stop();
    }

    private static final void startPaintCycle$lambda$1(BlackjackGameController this$0) {
        this$0.timer.start();
    }

    private static final void paintFelt$lambda$2(BlackjackGameController this$0, KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter(keyEvent, "keyEvent");
        this$0.handleKey(keyEvent);
    }

    private static final Unit paintFelt$lambda$3(BlackjackGameController this$0) {
        this$0.bge.exec("r");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$paintFelt(BlackjackGameController $this) {
        $this.paintFelt();
    }
}

