/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.Card;
import com.panopset.blackjackEngine.CardDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/panopset/blackjackEngine/BlackjackCard;", "", "card", "Lcom/panopset/blackjackEngine/Card;", "<init>", "(Lcom/panopset/blackjackEngine/Card;)V", "isShowing", "", "(Lcom/panopset/blackjackEngine/Card;Z)V", "cardDefinition", "Lcom/panopset/blackjackEngine/CardDefinition;", "(Lcom/panopset/blackjackEngine/CardDefinition;)V", "blackjackCard", "(Lcom/panopset/blackjackEngine/BlackjackCard;)V", "getCard", "()Lcom/panopset/blackjackEngine/Card;", "isAce", "getSoftValue", "", "getHardValue", "getNonAceValue", "toString", "", "show", "", "blackjackEngine"})
public final class BlackjackCard {
    @NotNull
    private final Card card;

    public BlackjackCard(@NotNull Card card) {
        Intrinsics.checkNotNullParameter(card, "card");
        this.card = card;
    }

    @NotNull
    public final Card getCard() {
        return this.card;
    }

    public BlackjackCard(@NotNull Card card, boolean isShowing) {
        Intrinsics.checkNotNullParameter(card, "card");
        this(card);
        card.setShowing(isShowing);
    }

    public BlackjackCard(@NotNull CardDefinition cardDefinition) {
        Intrinsics.checkNotNullParameter((Object)cardDefinition, "cardDefinition");
        this(new Card(cardDefinition, false, 2, null));
    }

    public BlackjackCard(@NotNull BlackjackCard blackjackCard) {
        Intrinsics.checkNotNullParameter(blackjackCard, "blackjackCard");
        this(blackjackCard.card, blackjackCard.card.isShowing());
    }

    public final boolean isAce() {
        return this.card.getFace().getOffset() == 0;
    }

    public final int getSoftValue() {
        return this.isAce() ? 11 : this.getNonAceValue();
    }

    public final int getHardValue() {
        return this.isAce() ? 1 : this.getNonAceValue();
    }

    private final int getNonAceValue() {
        return this.card.getFace().getOffset() < 10 ? this.card.getFace().getOffset() + 1 : 10;
    }

    @NotNull
    public String toString() {
        return this.card.name();
    }

    public final void show() {
        this.card.setShowing(true);
    }
}

