/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.Configurable;
import com.panopset.blackjackEngine.Situation;
import com.panopset.blackjackEngine.StratCat;
import com.panopset.blackjackEngine.StrategyLine;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eH\u0002R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/panopset/blackjackEngine/Strategy;", "Lcom/panopset/blackjackEngine/Configurable;", "blackjackConfiguration", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "<init>", "(Lcom/panopset/blackjackEngine/BlackjackConfiguration;)V", "rawData", "", "", "getRawData", "()Ljava/util/List;", "setRawData", "(Ljava/util/List;)V", "sls", "", "Lcom/panopset/blackjackEngine/StratCat;", "", "Lcom/panopset/blackjackEngine/StrategyLine;", "hardHeader", "softHeader", "splitHeader", "getRecommendation", "s", "Lcom/panopset/blackjackEngine/Situation;", "getHeaderFor", "cat", "populateStrategyLineMap", "", "findStrategyLine", "shouldSplit", "", "findSplitStrategyLine", "findSoftStrategyLine", "findHardStrategyLine", "createStrategyLineMap", "blackjackEngine"})
public final class Strategy
extends Configurable {
    @NotNull
    private List<String> rawData;
    @Nullable
    private Map<StratCat, ? extends Map<String, StrategyLine>> sls;
    private String hardHeader;
    private String softHeader;
    private String splitHeader;

    public Strategy(@NotNull BlackjackConfiguration blackjackConfiguration) {
        Intrinsics.checkNotNullParameter(blackjackConfiguration, "blackjackConfiguration");
        super(blackjackConfiguration);
        this.rawData = blackjackConfiguration.getStrategyData();
        this.sls = this.createStrategyLineMap();
        if (this.rawData.isEmpty()) {
            throw new RuntimeException("no data for strategy found.");
        }
        this.populateStrategyLineMap();
    }

    @NotNull
    public final List<String> getRawData() {
        return this.rawData;
    }

    public final void setRawData(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.rawData = list;
    }

    @NotNull
    public final String getRecommendation(@NotNull Situation s) {
        StrategyLine line;
        Intrinsics.checkNotNullParameter(s, "s");
        StrategyLine strategyLine = line = this.findStrategyLine(s);
        Intrinsics.checkNotNull(strategyLine);
        return strategyLine.getAction(s);
    }

    @NotNull
    public final String getHeaderFor(@Nullable StratCat cat) {
        String string;
        StratCat stratCat = cat;
        switch (stratCat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[stratCat.ordinal()]) {
            case 1: {
                string = this.softHeader;
                if (string != null) break;
                Intrinsics.throwUninitializedPropertyAccessException("softHeader");
                string = null;
                break;
            }
            case 2: {
                string = this.splitHeader;
                if (string != null) break;
                Intrinsics.throwUninitializedPropertyAccessException("splitHeader");
                string = null;
                break;
            }
            default: {
                string = this.hardHeader;
                if (string != null) break;
                Intrinsics.throwUninitializedPropertyAccessException("hardHeader");
                string = null;
            }
        }
        return string;
    }

    private final void populateStrategyLineMap() {
        StratCat reading = StratCat.NONE;
        for (String s : this.rawData) {
            StrategyLine sl;
            if (((CharSequence)s).length() == 0) continue;
            String string = s.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            if (Intrinsics.areEqual(string, "#")) continue;
            String string2 = StratCat.HARD.toString();
            String string3 = s.substring(0, 4);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            if (StringsKt.equals(string2, string3, true)) {
                reading = StratCat.HARD;
                this.hardHeader = s;
                continue;
            }
            String string4 = StratCat.SOFT.toString();
            String string5 = s.substring(0, 4);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            if (StringsKt.equals(string4, string5, true)) {
                reading = StratCat.SOFT;
                this.softHeader = s;
                continue;
            }
            String string6 = StratCat.SPLIT.toString();
            String string7 = s.substring(0, 5);
            Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
            if (StringsKt.equals(string6, string7, true)) {
                reading = StratCat.SPLIT;
                this.splitHeader = s;
                continue;
            }
            if (StratCat.HARD == reading) {
                sl = new StrategyLine(StratCat.HARD, s, this.getBlackjackConfiguration());
                Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
                Intrinsics.checkNotNull(map);
                Map<String, StrategyLine> map2 = map.get((Object)StratCat.HARD);
                Intrinsics.checkNotNull(map2);
                map2.put(sl.getKey(), sl);
                continue;
            }
            if (StratCat.SOFT == reading) {
                sl = new StrategyLine(StratCat.SOFT, s, this.getBlackjackConfiguration());
                Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
                Intrinsics.checkNotNull(map);
                Map<String, StrategyLine> map3 = map.get((Object)StratCat.SOFT);
                Intrinsics.checkNotNull(map3);
                map3.put(sl.getKey(), sl);
                continue;
            }
            sl = new StrategyLine(StratCat.SPLIT, s, this.getBlackjackConfiguration());
            Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
            Intrinsics.checkNotNull(map);
            Map<String, StrategyLine> map4 = map.get((Object)StratCat.SPLIT);
            Intrinsics.checkNotNull(map4);
            map4.put(sl.getKey(), sl);
        }
    }

    @Nullable
    public final StrategyLine findStrategyLine(@NotNull Situation s) {
        StrategyLine strategyLine;
        Intrinsics.checkNotNullParameter(s, "s");
        if (s.getHandPlayer() == null) {
            return null;
        }
        StrategyLine rtn2 = null;
        if (this.shouldSplit(s)) {
            rtn2 = this.findSplitStrategyLine(s);
        }
        if (rtn2 != null) {
            return rtn2;
        }
        if (s.getHandPlayer().isSoft()) {
            rtn2 = this.findSoftStrategyLine(s);
        }
        if ((strategyLine = rtn2) == null) {
            strategyLine = this.findHardStrategyLine(s);
        }
        return strategyLine;
    }

    private final boolean shouldSplit(Situation s) {
        if (s.getHandPlayer() == null) {
            return false;
        }
        if (s.getHandPlayer().isInitialDeal() && s.getHandPlayer().isCardFacesSplittable()) {
            int v = s.getHandPlayer().getFirstCard().getHardValue();
            return v != 5 && v != 10;
        }
        return false;
    }

    private final StrategyLine findSplitStrategyLine(Situation s) {
        if (s.getHandPlayer() == null) {
            return null;
        }
        int cv = s.getHandPlayer().getFirstCard().getHardValue();
        Object key = cv + "," + cv;
        if (Intrinsics.areEqual(key, "1,1")) {
            key = "A,A";
        }
        Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
        Intrinsics.checkNotNull(map);
        Map<String, StrategyLine> map2 = map.get((Object)StratCat.SPLIT);
        Intrinsics.checkNotNull(map2);
        return map2.get(key);
    }

    private final StrategyLine findSoftStrategyLine(Situation s) {
        if (s.getHandPlayer() == null) {
            return null;
        }
        int v = s.getHandPlayer().getHandValue();
        String key = v > 19 ? "20+" : String.valueOf(v);
        Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
        Intrinsics.checkNotNull(map);
        Map<String, StrategyLine> map2 = map.get((Object)StratCat.SOFT);
        Intrinsics.checkNotNull(map2);
        return map2.get(key);
    }

    private final StrategyLine findHardStrategyLine(Situation s) {
        if (s.getHandPlayer() == null) {
            return null;
        }
        int v = s.getHandPlayer().getHandValue();
        String key = v > 17 ? "18+" : (v < 8 ? "7" : String.valueOf(v));
        Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
        Intrinsics.checkNotNull(map);
        Map<String, StrategyLine> map2 = map.get((Object)StratCat.HARD);
        Intrinsics.checkNotNull(map2);
        return map2.get(key);
    }

    private final Map<StratCat, Map<String, StrategyLine>> createStrategyLineMap() {
        Map rtn2 = new EnumMap(StratCat.class);
        rtn2.put(StratCat.HARD, new HashMap());
        rtn2.put(StratCat.SOFT, new HashMap());
        rtn2.put(StratCat.SPLIT, new HashMap());
        return rtn2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StratCat.values().length];
            try {
                nArray[StratCat.SOFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StratCat.SPLIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

