/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.panopset.PanopsetBranding;
import com.panopset.desk.utilities.fwtabs.TabChisel;
import com.panopset.desk.utilities.fwtabs.TabFlywheel;
import com.panopset.desk.utilities.fwtabs.TabGlobalOptions;
import com.panopset.desk.utilities.fwtabs.TabGlobalReplace;
import com.panopset.desk.utilities.fwtabs.TabHexDump;
import com.panopset.desk.utilities.fwtabs.TabLineRemover;
import com.panopset.desk.utilities.fwtabs.TabListAudit;
import com.panopset.desk.utilities.fwtabs.TabStract;
import com.panopset.fxapp.ApplicationBranding;
import com.panopset.fxapp.ApplicationInfo;
import com.panopset.fxapp.BrandedApp;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactory;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/panopset/desk/utilities/Flywheel;", "Lcom/panopset/fxapp/BrandedApp;", "<init>", "()V", "createDynapane", "Ljavafx/scene/layout/Pane;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "createTabPane", "Ljavafx/scene/control/TabPane;", "Companion", "desk"})
public final class Flywheel
extends BrandedApp {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Flywheel() {
        super(new ApplicationInfo(){

            @Override
            public ApplicationBranding getApplicationBranding() {
                return new PanopsetBranding();
            }

            @Override
            public String getApplicationDisplayName() {
                return "Flywheel text utilities.";
            }

            @Override
            public String getDescription() {
                return "Text processing utilities (flywheel, hexdump, global replace, list audit.)";
            }

            @Override
            public void updateVersionMessage(FxDoc fxDoc) {
                ApplicationInfo.DefaultImpls.updateVersionMessage(this, fxDoc);
            }
        });
    }

    @Override
    @NotNull
    public Pane createDynapane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        BorderPane b = this.createStandardMenubarBorderPane(fxDoc);
        b.setCenter(this.createTabPane(fxDoc));
        return b;
    }

    private final TabPane createTabPane(FxDoc fxDoc) {
        TabPane rtn2 = PanComponentFactory.INSTANCE.createPanTabPane(fxDoc, "fwMainTabSelected");
        rtn2.getTabs().add(new TabFlywheel(fxDoc).createTab());
        rtn2.getTabs().add(new TabGlobalReplace(fxDoc).createTab());
        rtn2.getTabs().add(new TabHexDump(fxDoc).createTab());
        rtn2.getTabs().add(new TabLineRemover(fxDoc).createTab());
        rtn2.getTabs().add(new TabListAudit(fxDoc).createTab());
        rtn2.getTabs().add(new TabStract(fxDoc).createTab());
        rtn2.getTabs().add(new TabGlobalOptions().createTab(fxDoc));
        rtn2.getTabs().add(new TabChisel().createTab(fxDoc));
        return rtn2;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/desk/utilities/Flywheel$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "desk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            new Flywheel().go();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

