/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.compat.Rezop;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.Flywheel;
import com.panopset.flywheel.LineFeedRulesKt;
import com.panopset.flywheel.MatchableCommand;
import com.panopset.flywheel.NamedMap;
import com.panopset.flywheel.SourceFile;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateArray;
import com.panopset.flywheel.TemplateLine;
import com.panopset.flywheel.TokenVariableFactory;
import com.panopset.flywheel.UserMatchableCommand;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/panopset/flywheel/CommandList;", "Lcom/panopset/flywheel/MatchableCommand;", "Lcom/panopset/flywheel/UserMatchableCommand;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "innerPiece", "", "template", "Lcom/panopset/flywheel/Template;", "<init>", "(Lcom/panopset/flywheel/TemplateLine;Ljava/lang/String;Lcom/panopset/flywheel/Template;)V", "resolve", "", "sw", "Ljava/io/StringWriter;", "processValue", "str", "Companion", "flywheel"})
public final class CommandList
extends MatchableCommand
implements UserMatchableCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandList(@NotNull TemplateLine templateLine, @NotNull String innerPiece, @NotNull Template template) {
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        Intrinsics.checkNotNullParameter(innerPiece, "innerPiece");
        Intrinsics.checkNotNullParameter(template, "template");
        super(templateLine, innerPiece, template);
    }

    @Override
    public void resolve(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        SourceFile sourceFile = new SourceFile(this.getTemplate().getFlywheel(), this.getParams());
        List<String> lines = new ArrayList();
        if (sourceFile.isValid()) {
            lines = sourceFile.getTheSourceLines();
        } else {
            InputStream inputStream = this.getClass().getResourceAsStream(this.getParams());
            if (inputStream != null) {
                lines = Rezop.INSTANCE.textStreamToList(inputStream);
            }
        }
        if (lines == null || lines.isEmpty()) {
            return;
        }
        String tokens = this.getTemplate().getFlywheel().getEntry("com.panopset.flywheel.tokens");
        String splits = this.getTemplate().getFlywheel().getEntry("com.panopset.flywheel.splits");
        Stack<NamedMap<String, String>> stack = this.getTemplate().getFlywheel().getMapStack();
        String string = "key_%d_%s";
        Object[] objectArray = new Object[]{Stringop.INSTANCE.getNextJvmUniqueID(), this.getParams()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        stack.push(new NamedMap(string2, null, 2, null));
        for (String s : lines) {
            if (!Stringop.INSTANCE.isPopulated(s)) continue;
            String string3 = "CommandList line:%s";
            Object[] objectArray2 = new Object[]{s};
            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            Logz.INSTANCE.debug(string4);
            new TokenVariableFactory().addTokensToMap(this.getTemplate().getFlywheel().getTopMap(), s, tokens, this.getTemplate());
            if (Stringop.INSTANCE.isPopulated(splits)) {
                StringTokenizer st = new StringTokenizer(splits, ",");
                int count = 1;
                int startAt = 0;
                int split = 0;
                while (st.hasMoreElements()) {
                    String string5 = st.nextToken();
                    Intrinsics.checkNotNullExpressionValue(string5, "nextToken(...)");
                    split = Integer.parseInt(string5) - 1;
                    if (s.length() < split) continue;
                    Flywheel flywheel2 = this.getTemplate().getFlywheel();
                    String string6 = "" + count++;
                    String string7 = s.substring(startAt, split);
                    Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
                    flywheel2.put(string6, this.processValue(string7));
                    startAt = split;
                }
                if (s.length() > split) {
                    Flywheel flywheel3 = this.getTemplate().getFlywheel();
                    String string8 = "%d";
                    Object[] objectArray3 = new Object[]{count};
                    String string9 = String.format(string8, Arrays.copyOf(objectArray3, objectArray3.length));
                    Intrinsics.checkNotNullExpressionValue(string9, "format(...)");
                    String string10 = s.substring(split);
                    Intrinsics.checkNotNullExpressionValue(string10, "substring(...)");
                    flywheel3.put(string9, this.processValue(string10));
                }
            } else {
                this.getTemplate().getFlywheel().put("1", this.processValue(s));
            }
            this.resolveMatchedCommands(sw);
        }
        this.getTemplate().getFlywheel().getMapStack().pop();
    }

    private final String processValue(String str) {
        StringWriter sw = new StringWriter();
        String[] stringArray = new String[]{str};
        new Template(this.getTemplate().getFlywheel(), new TemplateArray(stringArray), LineFeedRulesKt.getLFR_FLATTEN()).exec(sw);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/panopset/flywheel/CommandList$Companion;", "", "<init>", "()V", "shortHtmlText", "", "getShortHtmlText", "()Ljava/lang/String;", "flywheel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShortHtmlText() {
            return "${&#064;l someListFile.txt}";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

