/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.MapProvider;
import com.panopset.compat.NetworkInfo;
import com.panopset.compat.Nls;
import com.panopset.compat.Propop;
import com.panopset.compat.Rezop;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandFile;
import com.panopset.flywheel.Control;
import com.panopset.flywheel.FlywheelBuilder;
import com.panopset.flywheel.Javop;
import com.panopset.flywheel.LineFeedRules;
import com.panopset.flywheel.LineFeedRulesKt;
import com.panopset.flywheel.NamedMap;
import com.panopset.flywheel.ScriptSecurity;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateSource;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\r\u0018\u0000 t2\u00020\u0001:\u0001tB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0019J\u0016\u0010E\u001a\u0002092\u0006\u0010F\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0019J\u000e\u0010G\u001a\u00020\u00192\u0006\u0010H\u001a\u00020\u0019J\u0010\u0010I\u001a\u0002092\b\u0010\n\u001a\u0004\u0018\u00010\u0019J\u0010\u0010J\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u0019H\u0016J\u001a\u0010K\u001a\u0002092\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u001dJ\u0006\u0010M\u001a\u00020\u0019J\u0006\u0010N\u001a\u00020\tJ\u000e\u0010O\u001a\u0002092\u0006\u0010P\u001a\u00020\u0019J\u0006\u0010S\u001a\u00020\u0019J\u000e\u0010T\u001a\u00020\u00192\u0006\u0010U\u001a\u00020\u0019J\u0010\u0010d\u001a\u0002092\b\u0010\n\u001a\u0004\u0018\u00010\u0019J\u0010\u0010e\u001a\u0002092\b\u0010\n\u001a\u0004\u0018\u00010\u0019J\u0010\u0010f\u001a\u0002092\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010k\u001a\u0002092\u0006\u0010\n\u001a\u00020\u0019J\u0016\u0010l\u001a\u0002092\u0006\u0010m\u001a\u00020\u00192\u0006\u0010n\u001a\u00020\u0019R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001f\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00190!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R&\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190+0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u000201\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u0004\u0018\u0001038FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010?R\u001a\u0010@\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0014\u0010Q\u001a\u00020>X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010?R\u0010\u0010R\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010V\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010?R&\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002010XX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u0011\u0010]\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R\u001a\u0010a\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010?\"\u0004\bb\u0010cR\u0017\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00190h\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010jR\u001a\u0010o\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010q\"\u0004\br\u0010s\u00a8\u0006u"}, d2={"Lcom/panopset/flywheel/Flywheel;", "Lcom/panopset/compat/MapProvider;", "sls", "Lcom/panopset/flywheel/TemplateSource;", "<init>", "(Lcom/panopset/flywheel/TemplateSource;)V", "getSls", "()Lcom/panopset/flywheel/TemplateSource;", "daTemplate", "Lcom/panopset/flywheel/Template;", "value", "Ljava/io/File;", "targetDirectory", "getTargetDirectory", "()Ljava/io/File;", "file", "resolvingCommand", "Lcom/panopset/flywheel/Command;", "getResolvingCommand", "()Lcom/panopset/flywheel/Command;", "pwriter", "Ljava/io/StringWriter;", "mapStack", "Ljava/util/Stack;", "Lcom/panopset/flywheel/NamedMap;", "", "getMapStack", "()Ljava/util/Stack;", "topMap", "", "getTopMap", "()Ljava/util/Map;", "allValues", "", "getAllValues", "currentCommandFile", "Lcom/panopset/flywheel/CommandFile;", "getCurrentCommandFile", "()Lcom/panopset/flywheel/CommandFile;", "setCurrentCommandFile", "(Lcom/panopset/flywheel/CommandFile;)V", "replacements", "Ljava/util/ArrayList;", "", "getReplacements", "()Ljava/util/ArrayList;", "setReplacements", "(Ljava/util/ArrayList;)V", "registeredObjs", "", "lineFeedRules", "Lcom/panopset/flywheel/LineFeedRules;", "getLineFeedRules", "()Lcom/panopset/flywheel/LineFeedRules;", "setLineFeedRules", "(Lcom/panopset/flywheel/LineFeedRules;)V", "copyPackageResource", "", "template", "resourcePath", "targetPath", "isTargetDirectoryValid", "", "()Z", "writer", "getWriter", "()Ljava/io/StringWriter;", "setWriter", "(Ljava/io/StringWriter;)V", "put", "key", "loadProperties", "relativePath", "suppressReplacements", "getEntry", "mergeMap", "map", "exec", "getTemplate", "stop", "message", "isStopped", "baseDirectoryPath", "getBaseDirectoryPath", "getBaseRelativePath", "simpleFileName", "isReplacementsSuppressed", "registeredObjects", "Ljava/util/HashMap;", "getRegisteredObjects", "()Ljava/util/HashMap;", "setRegisteredObjects", "(Ljava/util/HashMap;)V", "control", "Lcom/panopset/flywheel/Control;", "getControl", "()Lcom/panopset/flywheel/Control;", "isOutputEnabled", "setOutputEnabled", "(Z)V", "setBaseDirectoryPath", "setTargetDirectory", "setFile", "findLines", "", "getFindLines", "()Ljava/util/List;", "setFindLine", "setFindLines", "v0", "v1", "combine", "getCombine", "()Ljava/lang/String;", "setCombine", "(Ljava/lang/String;)V", "Companion", "flywheel"})
public final class Flywheel
implements MapProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TemplateSource sls;
    @Nullable
    private Template daTemplate;
    @Nullable
    private File targetDirectory;
    @Nullable
    private File file;
    @Nullable
    private final Command resolvingCommand;
    @Nullable
    private StringWriter pwriter;
    @NotNull
    private final Stack<NamedMap<String, String>> mapStack;
    @Nullable
    private CommandFile currentCommandFile;
    @NotNull
    private ArrayList<String[]> replacements;
    @Nullable
    private Map<String, Object> registeredObjs;
    @Nullable
    private LineFeedRules lineFeedRules;
    @NotNull
    private StringWriter writer;
    private final boolean isStopped;
    @Nullable
    private String baseDirectoryPath;
    @NotNull
    private HashMap<String, Object> registeredObjects;
    @NotNull
    private final Control control;
    private boolean isOutputEnabled;
    @NotNull
    private final List<String> findLines;
    @NotNull
    private String combine;

    public Flywheel(@Nullable TemplateSource sls) {
        this.sls = sls;
        this.mapStack = new Stack();
        this.replacements = new ArrayList();
        this.writer = new StringWriter();
        this.registeredObjects = new HashMap();
        this.control = new Control();
        this.isOutputEnabled = true;
        this.findLines = new ArrayList();
        this.combine = "";
        ScriptSecurity.INSTANCE.defineAllowedScriptCalls();
        this.mapStack.push(new NamedMap(Stringop.INSTANCE.getNextJvmUniqueIDstr(), null, 2, null));
        Object object = this.sls;
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        this.mapStack.peek().put("com.panopset.flywheel.file", (String)object);
        this.mapStack.peek().put("com.panopset.MACAddress", NetworkInfo.INSTANCE.getMaca());
    }

    @Nullable
    public final TemplateSource getSls() {
        return this.sls;
    }

    @Nullable
    public final File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Nullable
    public final Command getResolvingCommand() {
        return this.resolvingCommand;
    }

    @NotNull
    public final Stack<NamedMap<String, String>> getMapStack() {
        return this.mapStack;
    }

    @NotNull
    public final Map<String, String> getTopMap() {
        NamedMap<String, String> namedMap = this.mapStack.peek();
        return namedMap.getMap();
    }

    @NotNull
    public final Map<String, String> getAllValues() {
        Map<String, String> rtn2 = Collections.synchronizedMap(new TreeMap());
        Iterator iterator2 = this.mapStack.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            NamedMap nm = (NamedMap)iterator3.next();
            for (Map.Entry entry : nm.getMap().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Intrinsics.checkNotNull(rtn2);
                rtn2.put(key, value);
            }
        }
        Intrinsics.checkNotNull(rtn2);
        return rtn2;
    }

    @Nullable
    public final CommandFile getCurrentCommandFile() {
        return this.currentCommandFile;
    }

    public final void setCurrentCommandFile(@Nullable CommandFile commandFile) {
        this.currentCommandFile = commandFile;
    }

    @NotNull
    public final ArrayList<String[]> getReplacements() {
        return this.replacements;
    }

    public final void setReplacements(@NotNull ArrayList<String[]> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.replacements = arrayList;
    }

    @Nullable
    public final LineFeedRules getLineFeedRules() {
        if (this.lineFeedRules == null) {
            this.lineFeedRules = LineFeedRulesKt.getFULL_BREAKS();
        }
        return this.lineFeedRules;
    }

    public final void setLineFeedRules(@Nullable LineFeedRules lineFeedRules) {
        this.lineFeedRules = lineFeedRules;
    }

    public final void copyPackageResource(@NotNull Template template, @NotNull String resourcePath, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(targetPath, "targetPath");
        try {
            if (this.targetDirectory == null) {
                return;
            }
            Class<?> clazz = this.getClass();
            File file = this.targetDirectory;
            Intrinsics.checkNotNull(file);
            Rezop.INSTANCE.copyTextResourceToFile(clazz, resourcePath, Fileop.INSTANCE.getCanonicalPath(file) + "/" + targetPath);
        }
        catch (IOException ex) {
            StringWriter sw = new StringWriter();
            sw.append("baseDirectoryPath: " + this.baseDirectoryPath);
            sw.append(Stringop.INSTANCE.getEol());
            File file = this.file;
            Intrinsics.checkNotNull(file);
            sw.append("Template file: " + Fileop.INSTANCE.getCanonicalPath(file));
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("targetDirectory: " + this.targetDirectory);
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("resourcePath: " + resourcePath);
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("targetPath: " + targetPath);
            sw.append(Stringop.INSTANCE.getEol());
            template.getTemplateSource();
            sw.append("executing from: " + template.getTemplateSource().getName());
            sw.append(Stringop.INSTANCE.getEol());
            sw.append("Line: ");
            sw.append("" + template.getTemplateSource().getLine());
            sw.append(Stringop.INSTANCE.getEol());
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            Logz.INSTANCE.warn(string);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTargetDirectoryValid() {
        if (this.targetDirectory != null) {
            File file = this.targetDirectory;
            Intrinsics.checkNotNull(file);
            if (!file.exists()) {
                File file2 = this.targetDirectory;
                Intrinsics.checkNotNull(file2);
                Fileop.INSTANCE.mkdirs(file2);
            }
        }
        if (this.targetDirectory == null) return false;
        File file = this.targetDirectory;
        Intrinsics.checkNotNull(file);
        if (!file.isDirectory()) return false;
        File file3 = this.targetDirectory;
        Intrinsics.checkNotNull(file3);
        if (!file3.exists()) return false;
        File file4 = this.targetDirectory;
        Intrinsics.checkNotNull(file4);
        if (!file4.canWrite()) return false;
        return true;
    }

    @NotNull
    public final StringWriter getWriter() {
        return this.writer;
    }

    public final void setWriter(@NotNull StringWriter stringWriter) {
        Intrinsics.checkNotNullParameter(stringWriter, "<set-?>");
        this.writer = stringWriter;
    }

    public final void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.mapStack.peek().put(key, value);
    }

    @NotNull
    public final String loadProperties(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        File file = new File(this.getBaseDirectoryPath() + "/" + relativePath);
        Properties props = new Properties();
        if (!file.exists()) {
            try {
                Rezop.INSTANCE.copyTextResourceToFile(this.getClass(), relativePath, file);
            }
            catch (IOException ex) {
                Logz.INSTANCE.warn("relativePath: " + relativePath);
                Logz.INSTANCE.errorEx(ex);
            }
        }
        Propop.INSTANCE.load(props, file);
        for (Object k : props.keySet()) {
            String string = k.toString();
            String string2 = props.getProperty(k.toString());
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
            this.put(string, string2);
        }
        return "";
    }

    public final void suppressReplacements(@Nullable String value) {
        if (value == null) {
            this.control.setReplacementsSuppressed(false);
            return;
        }
        this.control.setReplacementsSuppressed(Boolean.parseBoolean(value));
    }

    @Override
    @NotNull
    public String getEntry(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (this.mapStack.isEmpty()) {
            this.stop("mapStack empty, this should be an impossible condition.");
            return "";
        }
        Stack<NamedMap> stack = new Stack<NamedMap>();
        Iterator iterator2 = this.mapStack.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            NamedMap item = (NamedMap)iterator3.next();
            stack.push(item);
        }
        while (!stack.isEmpty()) {
            NamedMap nm = (NamedMap)stack.pop();
            String rtn2 = (String)nm.get(key);
            if (rtn2 == null) continue;
            return rtn2;
        }
        if (Stringop.INSTANCE.isPopulated(key)) {
            String string;
            String rtn3 = System.getProperty(key);
            if (Stringop.INSTANCE.isPopulated(rtn3)) {
                string = rtn3;
                Intrinsics.checkNotNull(string);
                return string;
            }
            rtn3 = System.getenv(key);
            if (Stringop.INSTANCE.isPopulated(rtn3)) {
                string = rtn3;
                Intrinsics.checkNotNull(string);
                return string;
            }
        }
        return "";
    }

    public final void mergeMap(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        this.mapStack.push(new NamedMap<String, String>(Stringop.INSTANCE.getNextJvmUniqueIDstr(), map));
    }

    @NotNull
    public final String exec() {
        if (this.isStopped) {
            return "";
        }
        this.getTemplate().output();
        String string = this.writer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Template getTemplate() {
        if (this.daTemplate == null) {
            TemplateSource templateSource = this.sls;
            Intrinsics.checkNotNull(templateSource);
            LineFeedRules lineFeedRules = this.getLineFeedRules();
            Intrinsics.checkNotNull(lineFeedRules);
            this.daTemplate = new Template(this, templateSource, lineFeedRules);
        }
        Template template = this.daTemplate;
        Intrinsics.checkNotNull(template, "null cannot be cast to non-null type com.panopset.flywheel.Template");
        return template;
    }

    public final void stop(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Logz.INSTANCE.errorMsg(message);
        if (this.resolvingCommand != null) {
            Logz.INSTANCE.warn(Nls.INSTANCE.xlate("Stopped while executing line") + " " + this.resolvingCommand);
            Logz.INSTANCE.debug(" at: " + this.resolvingCommand);
        }
        Logz.INSTANCE.debug(Javop.INSTANCE.dump(this.mapStack.peek().getMap()));
        Logz.INSTANCE.warn(Nls.INSTANCE.xlate("Template parsing stopped.  Check debug in help->Show log, for more information"));
        this.control.stop(message);
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getBaseDirectoryPath() {
        block5: {
            if (this.baseDirectoryPath != null) break block5;
            v0 = this;
            if (this.file == null) ** GOTO lbl-1000
            v1 = this.file;
            Intrinsics.checkNotNull(v1);
            if (v1.exists()) {
                var3_1 = v0;
                try {
                    v0 = var3_1;
                    v2 = this.file;
                    Intrinsics.checkNotNull(v2);
                    var1_2 = v2.getParentFile().getCanonicalPath();
                }
                catch (IOException e) {
                    v3 = var3_1;
                    Logz.INSTANCE.errorEx(e);
                    return "";
                }
                v4 = var1_2;
            } else lbl-1000:
            // 2 sources

            {
                v4 = v0.baseDirectoryPath = System.getProperty("user.home");
            }
        }
        if ((v5 = this.baseDirectoryPath) == null) {
            v5 = "";
        }
        return v5;
    }

    @NotNull
    public final String getBaseRelativePath(@NotNull String simpleFileName) {
        Intrinsics.checkNotNullParameter(simpleFileName, "simpleFileName");
        return this.getBaseDirectoryPath() + "/" + simpleFileName;
    }

    public final boolean isReplacementsSuppressed() {
        return this.control.isReplacementsSuppressed();
    }

    @NotNull
    public final HashMap<String, Object> getRegisteredObjects() {
        return this.registeredObjects;
    }

    public final void setRegisteredObjects(@NotNull HashMap<String, Object> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.registeredObjects = hashMap;
    }

    @NotNull
    public final Control getControl() {
        return this.control;
    }

    public final boolean isOutputEnabled() {
        return this.isOutputEnabled;
    }

    public final void setOutputEnabled(boolean bl) {
        this.isOutputEnabled = bl;
    }

    public final void setBaseDirectoryPath(@Nullable String value) {
        if (value != null) {
            this.baseDirectoryPath = value;
        }
        if (this.file != null && this.baseDirectoryPath == null) {
            File file = this.file;
            Intrinsics.checkNotNull(file);
            this.baseDirectoryPath = Fileop.INSTANCE.getParentDirectory(file);
        }
    }

    public final void setTargetDirectory(@Nullable String value) {
        if (Stringop.INSTANCE.isPopulated(value)) {
            this.targetDirectory = new File(value);
        }
        if (this.targetDirectory == null) {
            this.targetDirectory = this.targetDirectory;
        }
    }

    public final void setFile(@Nullable File value) {
        if (value != null) {
            this.file = value;
            Map<String, String> map = this.getTopMap();
            File file = this.file;
            Intrinsics.checkNotNull(file);
            map.put("com.panopset.flywheel.template", file.getName());
        }
    }

    @NotNull
    public final List<String> getFindLines() {
        return this.findLines;
    }

    public final void setFindLine(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.findLines.clear();
        this.findLines.add(value);
    }

    public final void setFindLines(@NotNull String v0, @NotNull String v1) {
        Intrinsics.checkNotNullParameter(v0, "v0");
        Intrinsics.checkNotNullParameter(v1, "v1");
        this.findLines.clear();
        this.findLines.add(v0);
        this.findLines.add(v1);
    }

    @NotNull
    public final String getCombine() {
        return this.combine;
    }

    public final void setCombine(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.combine = string;
    }

    @JvmStatic
    public static final void main(String ... args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/flywheel/Flywheel$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "flywheel"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(String ... args) {
            Intrinsics.checkNotNullParameter(args, "args");
            if (args.length == 0 || args.length > 2) {
                Logz.INSTANCE.dspmsg("Params are script and target directory.");
            } else {
                Flywheel flywheel2;
                if (args.length == 1) {
                    flywheel2 = new FlywheelBuilder().properties(new File(args[0])).construct();
                } else {
                    String scriptFileName = args[0];
                    String targetDirectoryName = args[1];
                    File scriptFile = new File(scriptFileName);
                    File targetDirectory = new File(targetDirectoryName);
                    if (!scriptFile.exists()) {
                        Logz.INSTANCE.errorMsg("File does not exist.", scriptFile);
                        return;
                    }
                    if (!scriptFile.canRead()) {
                        Logz.INSTANCE.errorMsg("Can not read.", scriptFile);
                        return;
                    }
                    String string = "%s:%s";
                    Object[] objectArray = new Object[]{"Script file", Fileop.INSTANCE.getCanonicalPath(scriptFile)};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    Logz.INSTANCE.info(string2);
                    string = "%s:%s";
                    objectArray = new Object[]{"Target directory", Fileop.INSTANCE.getCanonicalPath(targetDirectory)};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                    Logz.INSTANCE.info(string3);
                    flywheel2 = new FlywheelBuilder().file(scriptFile).targetDirectory(targetDirectory).construct();
                }
                Flywheel flywheel3 = flywheel2;
                flywheel3.exec();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

