/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.AlertColor;
import com.panopset.compat.LogDisplayer;
import com.panopset.compat.LogEntry;
import com.panopset.compat.Logz;
import com.panopset.compat.StringFunKt;
import com.panopset.fxapp.Anchor;
import com.panopset.fxapp.FxDocMessage;
import com.panopset.fxapp.PanApplication;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u00103\u001a\u000204H\u0016J\u0006\u00105\u001a\u000204J\u0006\u00106\u001a\u000204J\u0010\u00107\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016J\b\u0010;\u001a\u000204H\u0016J\b\u0010<\u001a\u000209H\u0016J\u0010\u0010=\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010>\u001a\u0002042\u0006\u00108\u001a\u0002092\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010>\u001a\u0002042\u0006\u00108\u001a\u0002092\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010>\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010>\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u0002042\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010B\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018R \u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/panopset/fxapp/FxDoc;", "Lcom/panopset/fxapp/Anchor;", "Lcom/panopset/compat/LogDisplayer;", "panApplication", "Lcom/panopset/fxapp/PanApplication;", "stage", "Ljavafx/stage/Stage;", "file", "Ljava/io/File;", "<init>", "(Lcom/panopset/fxapp/PanApplication;Ljavafx/stage/Stage;Ljava/io/File;)V", "(Lcom/panopset/fxapp/PanApplication;Ljavafx/stage/Stage;)V", "logEntry", "Lcom/panopset/compat/LogEntry;", "getLogEntry", "()Lcom/panopset/compat/LogEntry;", "setLogEntry", "(Lcom/panopset/compat/LogEntry;)V", "mbs", "", "Ljavafx/scene/control/MenuBar;", "getMbs", "()Ljava/util/List;", "setMbs", "(Ljava/util/List;)V", "nodes", "Ljavafx/scene/Node;", "getNodes", "setNodes", "tabPanes", "Ljavafx/scene/control/TabPane;", "getTabPanes", "setTabPanes", "tabs", "Ljavafx/scene/control/Tab;", "getTabs", "setTabs", "getStage", "()Ljavafx/stage/Stage;", "fxDocMessage", "Lcom/panopset/fxapp/FxDocMessage;", "getFxDocMessage", "()Lcom/panopset/fxapp/FxDocMessage;", "scene", "Ljavafx/scene/Scene;", "getScene", "()Ljavafx/scene/Scene;", "setScene", "(Ljavafx/scene/Scene;)V", "closingSaveComplete", "", "updateTitle", "", "closeWindow", "saveWindow", "dspmsg", "msg", "", "warn", "clear", "getPriorMessage", "green", "errorMsg", "throwable", "", "errorEx", "debug", "fxapp"})
public final class FxDoc
extends Anchor
implements LogDisplayer {
    @NotNull
    private LogEntry logEntry;
    @NotNull
    private List<MenuBar> mbs;
    @NotNull
    private List<Node> nodes;
    @NotNull
    private List<TabPane> tabPanes;
    @NotNull
    private List<Tab> tabs;
    @NotNull
    private final Stage stage;
    @NotNull
    private final FxDocMessage fxDocMessage;
    public Scene scene;
    private boolean closingSaveComplete;

    @NotNull
    public final LogEntry getLogEntry() {
        return this.logEntry;
    }

    public final void setLogEntry(@NotNull LogEntry logEntry) {
        Intrinsics.checkNotNullParameter(logEntry, "<set-?>");
        this.logEntry = logEntry;
    }

    @NotNull
    public final List<MenuBar> getMbs() {
        return this.mbs;
    }

    public final void setMbs(@NotNull List<MenuBar> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.mbs = list;
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    public final void setNodes(@NotNull List<Node> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.nodes = list;
    }

    @NotNull
    public final List<TabPane> getTabPanes() {
        return this.tabPanes;
    }

    public final void setTabPanes(@NotNull List<TabPane> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.tabPanes = list;
    }

    @NotNull
    public final List<Tab> getTabs() {
        return this.tabs;
    }

    public final void setTabs(@NotNull List<Tab> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.tabs = list;
    }

    @NotNull
    public final Stage getStage() {
        return this.stage;
    }

    @NotNull
    public final FxDocMessage getFxDocMessage() {
        return this.fxDocMessage;
    }

    @NotNull
    public final Scene getScene() {
        Scene scene = this.scene;
        if (scene != null) {
            return scene;
        }
        Intrinsics.throwUninitializedPropertyAccessException("scene");
        return null;
    }

    public final void setScene(@NotNull Scene scene) {
        Intrinsics.checkNotNullParameter(scene, "<set-?>");
        this.scene = scene;
    }

    public FxDoc(@NotNull PanApplication panApplication, @NotNull Stage stage, @NotNull File file) {
        Intrinsics.checkNotNullParameter(panApplication, "panApplication");
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(file, "file");
        super(panApplication, file);
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue(level, "INFO");
        this.logEntry = new LogEntry(AlertColor.GRN, level, "");
        this.mbs = new ArrayList();
        this.nodes = new ArrayList();
        this.tabPanes = new ArrayList();
        this.tabs = new ArrayList();
        this.fxDocMessage = new FxDocMessage(this);
        this.stage = stage;
    }

    public FxDoc(@NotNull PanApplication panApplication, @NotNull Stage stage) {
        Intrinsics.checkNotNullParameter(panApplication, "panApplication");
        Intrinsics.checkNotNullParameter(stage, "stage");
        super(panApplication);
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue(level, "INFO");
        this.logEntry = new LogEntry(AlertColor.GRN, level, "");
        this.mbs = new ArrayList();
        this.nodes = new ArrayList();
        this.tabPanes = new ArrayList();
        this.tabs = new ArrayList();
        this.fxDocMessage = new FxDocMessage(this);
        this.stage = stage;
    }

    @Override
    public void updateTitle() {
        this.stage.setTitle(this.createWindowTitle());
    }

    public final void closeWindow() {
        this.saveWindow();
        this.closingSaveComplete = true;
        try {
            this.stage.close();
        }
        catch (Exception e) {
            Logz.INSTANCE.errorEx(e);
        }
    }

    public final void saveWindow() {
        if (this.closingSaveComplete) {
            return;
        }
        String[] stringArray = new String[]{String.valueOf(this.stage.getX()), String.valueOf(this.stage.getY()), String.valueOf(this.stage.getWidth()), String.valueOf(this.stage.getHeight())};
        this.getPmf().put("windowDims", StringFunKt.combineDelim("|", stringArray));
        this.saveDataToFile();
    }

    @Override
    public void dspmsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.fxDocMessage.setMsg(msg);
    }

    @Override
    public void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.dspmsg(msg);
    }

    @Override
    public void clear() {
        this.dspmsg("");
    }

    @Override
    @NotNull
    public String getPriorMessage() {
        return this.fxDocMessage.getPriorMessage();
    }

    @Override
    public void green(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.dspmsg(msg);
    }

    @Override
    public void errorMsg(@NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.fxDocMessage.setErrorMsg(msg);
    }

    @Override
    public void errorMsg(@NotNull String msg, @NotNull File file) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(file, "file");
        this.fxDocMessage.setErrorMsg(msg);
    }

    @Override
    public void errorMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.fxDocMessage.setErrorMsg(msg);
    }

    @Override
    public void errorMsg(@NotNull File file, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.fxDocMessage.setErrorMsg(throwable.getMessage() + ",\n" + file.getAbsolutePath());
    }

    @Override
    public void errorEx(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.fxDocMessage.setErrorMsg(String.valueOf(throwable.getMessage()));
    }

    @Override
    public void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.dspmsg(msg);
    }

    @Override
    public void info(@NotNull String msg) {
        LogDisplayer.DefaultImpls.info(this, msg);
    }
}

