/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.AlertColor;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactory;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/panopset/fxapp/SteelWrapper;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "theCurrentColor", "Lcom/panopset/compat/AlertColor;", "thePriorMessage", "", "theCurrentMessage", "mbStatusMessage", "Ljavafx/scene/control/TextField;", "setMsg", "", "msg", "refresh", "updateStyle", "alertColor", "addToPane", "menuBarStatusPane", "Ljavafx/scene/layout/HBox;", "getPriorMessage", "assembleStyle", "fxapp"})
public final class SteelWrapper {
    @NotNull
    private final FxDoc fxDoc;
    @NotNull
    private AlertColor theCurrentColor;
    @NotNull
    private String thePriorMessage;
    @NotNull
    private String theCurrentMessage;
    @NotNull
    private final TextField mbStatusMessage;

    public SteelWrapper(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
        this.theCurrentColor = AlertColor.GRN;
        this.thePriorMessage = "";
        this.theCurrentMessage = "";
        this.mbStatusMessage = PanComponentFactory.INSTANCE.createPanOutputTextField(this.fxDoc, "mbStatusMessage", "Use Help->Logs to see all logs.");
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    public final void setMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.thePriorMessage = this.theCurrentMessage;
        this.theCurrentMessage = msg;
        this.mbStatusMessage.setText(msg);
    }

    public final void refresh() {
        this.mbStatusMessage.setStyle(this.assembleStyle());
    }

    public final void updateStyle(@NotNull AlertColor alertColor) {
        Intrinsics.checkNotNullParameter((Object)alertColor, "alertColor");
        this.theCurrentColor = alertColor;
        this.mbStatusMessage.setStyle(this.assembleStyle());
    }

    public final void addToPane(@NotNull HBox menuBarStatusPane) {
        Intrinsics.checkNotNullParameter(menuBarStatusPane, "menuBarStatusPane");
        this.mbStatusMessage.setFocusTraversable(false);
        this.mbStatusMessage.setEditable(false);
        this.mbStatusMessage.setId("menubarStatusMessage");
        FontManagerFX.INSTANCE.register(this.fxDoc, this.mbStatusMessage);
        HBox.setHgrow(this.mbStatusMessage, Priority.ALWAYS);
        menuBarStatusPane.getChildren().add(this.mbStatusMessage);
    }

    @NotNull
    public final String getPriorMessage() {
        return this.thePriorMessage;
    }

    private final String assembleStyle() {
        String rootStyle = this.fxDoc.getScene().getRoot().getStyle();
        Intrinsics.checkNotNull(rootStyle);
        boolean isDark = ((CharSequence)rootStyle).length() == 0 ? false : rootStyle.equals("-fx-base:black");
        String hexFg = isDark ? this.theCurrentColor.getHexDkFg() : this.theCurrentColor.getHexLtFg();
        String hexBg = isDark ? this.theCurrentColor.getHexDkBg() : this.theCurrentColor.getHexLtBg();
        String fontStyle = FontManagerFX.INSTANCE.getStyleFor(FontManagerFX.INSTANCE.getFontSize().getValue());
        String rtn2 = rootStyle + "; -fx-background-color: #" + hexBg + "; -fx-text-fill: #" + hexFg + " " + fontStyle;
        return rtn2;
    }
}

