/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.games.blackjack;

import com.panopset.blackjackEngine.BlackjackConfigDefault;
import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.BlackjackMessages;
import com.panopset.blackjackEngine.CountingSystems;
import com.panopset.compat.Logz;
import com.panopset.fxapp.FxDoc;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/panopset/marin/games/blackjack/BlackjackConfigurationFactory;", "", "<init>", "()V", "create", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "desk"})
public final class BlackjackConfigurationFactory {
    @NotNull
    public static final BlackjackConfigurationFactory INSTANCE = new BlackjackConfigurationFactory();

    private BlackjackConfigurationFactory() {
    }

    @NotNull
    public final BlackjackConfiguration create(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        BlackjackConfigDefault blackjackConfigDefault = new BlackjackConfigDefault();
        BlackjackConfiguration rtn2 = new BlackjackConfiguration(fxDoc, blackjackConfigDefault){
            final /* synthetic */ FxDoc $fxDoc;
            final /* synthetic */ BlackjackConfigDefault $blackjackConfigDefault;
            {
                this.$fxDoc = $fxDoc;
                this.$blackjackConfigDefault = $blackjackConfigDefault;
            }

            public BlackjackMessages getMessages() {
                return new BlackjackConfigDefault().getMessages();
            }

            public boolean isDoubleAfterSplitAllowed() {
                return this.$fxDoc.getBooleanValue("dblaftrsplit");
            }

            public boolean isResplitAcesAllowed() {
                return this.$fxDoc.getBooleanValue("rspltaces");
            }

            public boolean isSplitAcePlayable() {
                return this.$fxDoc.getBooleanValue("rspltaces");
            }

            public ArrayList<String> getStrategyData() {
                ArrayList<String> rtn2 = this.$fxDoc.getArrayListValue("taBasic");
                ArrayList<String> dft = this.$blackjackConfigDefault.getStrategyData();
                if (rtn2.isEmpty()) {
                    rtn2 = dft;
                }
                if (!Intrinsics.areEqual(rtn2, dft)) {
                    Logz.INSTANCE.warn("Custom (or out of date) strategy data in use.  Go to config to reset.");
                }
                return rtn2;
            }

            public CountingSystems getCountingSystems() {
                CountingSystems countingSystems = new CountingSystems(this.$fxDoc.getArrayListValue("taCountingSystems"));
                String selectedCountingSystem = this.$fxDoc.getStringValue("cb_counting_systems");
                CountingSystems dft = this.$blackjackConfigDefault.getCountingSystems();
                if (countingSystems.getCountingSystemsData().isEmpty()) {
                    countingSystems = new CountingSystems(dft.getCountingSystemsData());
                }
                if (!Intrinsics.areEqual(countingSystems.getCountingSystemsData(), dft.getCountingSystemsData())) {
                    Logz.INSTANCE.warn("Custom (or out of date) counting system data in use.  Go to config to reset.");
                }
                countingSystems.setSystemByName(selectedCountingSystem);
                return countingSystems;
            }

            public int getSeats() {
                return this.$fxDoc.getIntValue("cb_seats");
            }

            public int getDecks() {
                return this.$fxDoc.getIntValue("cb_decks");
            }

            public boolean isDealerHitSoft17() {
                return this.$fxDoc.getBooleanValue("dealer_hits_soft_17");
            }

            public boolean isBlackjack6to5() {
                return this.$fxDoc.getBooleanValue("rule_65");
            }

            public boolean isEvenMoneyOnBlackjackVace() {
                return this.$fxDoc.getBooleanValue("rule_65");
            }

            public boolean isLateSurrenderAllowed() {
                return this.$fxDoc.getBooleanValue("rule_ls");
            }

            public boolean isEuropeanStyle() {
                return this.$fxDoc.getBooleanValue("rule_ls");
            }

            public boolean isFastDeal() {
                return this.$fxDoc.getBooleanValue("rule_fd");
            }

            public boolean isBasicStrategyVariationsOnly() {
                return this.$fxDoc.getBooleanValue("rule_vs");
            }

            public boolean isShowCount() {
                return this.$fxDoc.getBooleanValue("rule_sc");
            }

            public void toggleShowCount() {
                this.$fxDoc.toggle("rule_sc");
            }

            public int getLargeBetInWholeDollars() {
                return this.$fxDoc.getIntValue("large_bet");
            }

            public int getTargetStakeInWholeDollars() {
                return this.$fxDoc.getIntValue("target_stake");
            }

            public int getMinimumBetInWholeDollars() {
                return this.$fxDoc.getIntValue("minimum_bet");
            }

            public int getBetIncrementInWholeDollars() {
                return this.$fxDoc.getIntValue("increment_bet");
            }

            public int getReloadAmountInWholeDollars() {
                return this.$fxDoc.getIntValue("reload_amount");
            }

            public int getStrategicVeryPositiveCount() {
                return this.$fxDoc.getIntValue("count_positive");
            }
        };
        return rtn2;
    }
}

