/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.oldswpkg.games.blackjack;

import com.panopset.blackjackEngine.Card;
import com.panopset.blackjackEngine.Suit;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.marin.game.card.images.BlackjackImages;
import com.panopset.marin.oldswpkg.cards.pngmap.CardLocation;
import com.panopset.marin.oldswpkg.cards.pngmap.CardPainter;
import com.panopset.marin.oldswpkg.games.blackjack.CardPathKeys;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J(\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J0\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\n\u0010,\u001a\u0004\u0018\u00010+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR&\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010 \u001a\u0004\u0018\u00010\t8F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R\u0011\u0010%\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/panopset/marin/oldswpkg/games/blackjack/FxCardPainter;", "", "<init>", "()V", "cp", "Lcom/panopset/marin/oldswpkg/cards/pngmap/CardPainter;", "sck", "Lcom/panopset/marin/oldswpkg/games/blackjack/CardPathKeys;", "cw", "", "ch", "order", "", "Lcom/panopset/blackjackEngine/Suit;", "getOrder", "()[Lcom/panopset/blackjackEngine/Suit;", "paintCard", "", "g", "Ljavafx/scene/canvas/GraphicsContext;", "cl", "Lcom/panopset/marin/oldswpkg/cards/pngmap/CardLocation;", "card", "Lcom/panopset/blackjackEngine/Card;", "x", "y", "getCardPath", "", "paintCardSvg", "paintCardBitmap", "hlt", "Ljavafx/scene/paint/Color;", "value", "border", "getBorder", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "cardHeight", "getCardHeight", "()I", "cardWidth", "getCardWidth", "mapImg", "Ljavafx/scene/image/Image;", "getMapImg", "Companion", "desk"})
public final class FxCardPainter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CardPainter cp;
    @NotNull
    private final CardPathKeys sck;
    private final int cw;
    private final int ch;
    @Nullable
    private Integer border;
    @Nullable
    private Image mapImg;
    @NotNull
    private static final String BASE_PATH = "/com/panopset/marin/game/card/lg/";

    public FxCardPainter() {
        Image image = this.getMapImg();
        Intrinsics.checkNotNull(image);
        double mw = image.getWidth();
        Image image2 = this.getMapImg();
        Intrinsics.checkNotNull(image2);
        double mh = image2.getHeight();
        this.cp = new CardPainter((int)mw, (int)mh, null, 4, null);
        this.sck = new CardPathKeys(BASE_PATH, "png");
        this.ch = (int)((double)98 * FontManagerFX.INSTANCE.getSvgRatio());
        this.cw = (int)((double)73 * FontManagerFX.INSTANCE.getSvgRatio());
    }

    @NotNull
    public final Suit[] getOrder() {
        return this.cp.getOrder();
    }

    public final void paintCard(@NotNull GraphicsContext g, @NotNull CardLocation cl) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(cl, "cl");
        Card card = cl.getCard();
        Intrinsics.checkNotNullExpressionValue(card, "getCard(...)");
        this.paintCard(g, card, cl.x, cl.y);
    }

    public final void paintCard(@NotNull GraphicsContext g, @NotNull Card card, int x, int y) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(card, "card");
        this.paintCardSvg(g, card, x, y);
    }

    @NotNull
    public final String getCardPath(@Nullable Card card) {
        if (card == null) {
            return "";
        }
        Object object = this.sck.getImage(card);
        if (object == null || (object = ((Image)object).getUrl()) == null) {
            object = "";
        }
        return object;
    }

    private final void paintCardSvg(GraphicsContext g, Card card, int x, int y) {
        if (card.isShowing()) {
            g.drawImage(this.sck.getImage(card), x, y, this.cw, this.ch);
        } else if (card.isBlue()) {
            g.drawImage(this.sck.getBackBlue(), x, y, this.cw, this.ch);
        } else {
            g.drawImage(this.sck.getBackRed(), x, y, this.cw, this.ch);
        }
    }

    public final void paintCardBitmap(@NotNull GraphicsContext g, @NotNull Card card, int x, int y, @Nullable Color hlt) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(card, "card");
        int[] b = this.cp.getPaintDimensionsFX(card, x, y);
        int arc = 10;
        if (card.isShowing()) {
            g.drawImage(this.mapImg, b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]);
        } else {
            if (card.isBlue()) {
                g.setFill(Color.BLUE);
            } else {
                g.setFill(Color.RED);
            }
            g.fillRoundRect(b[4], b[5], b[6], b[7], arc, arc);
            Integer n = this.getBorder();
            Intrinsics.checkNotNull(n);
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                g.strokeRect(b[4] + i, b[5] + i, b[6] - i * 2, b[7] - i * 2);
            }
        }
        g.setFill(hlt);
        g.strokeRect(b[4], b[5], b[6], b[7]);
    }

    @Nullable
    public final Integer getBorder() {
        if (this.border == null) {
            this.border = this.getCardWidth() > 30 ? Integer.valueOf(this.getCardWidth() / 30) : Integer.valueOf(1);
        }
        return this.border;
    }

    public final int getCardHeight() {
        return this.cp.getCardHeight();
    }

    public final int getCardWidth() {
        return this.cp.getCardWidth();
    }

    private final Image getMapImg() {
        if (this.mapImg == null) {
            this.mapImg = BlackjackImages.INSTANCE.getCardMap();
        }
        return this.mapImg;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panopset/marin/oldswpkg/games/blackjack/FxCardPainter$Companion;", "", "<init>", "()V", "BASE_PATH", "", "desk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

