/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.oldswpkg.games.blackjack;

import com.panopset.blackjackEngine.BlackjackGameState;
import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Player;
import com.panopset.compat.Tile;
import com.panopset.marin.oldswpkg.games.blackjack.Layout;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR&\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f8F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f8F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0017\u0010\u0014R&\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f8F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0019\u0010\u0014R&\u0010\u001a\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f8F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u001b\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/panopset/marin/oldswpkg/games/blackjack/LayoutPlayer;", "Lcom/panopset/marin/oldswpkg/games/blackjack/Layout;", "tile", "Lcom/panopset/compat/Tile;", "cardDim", "", "cs", "Lcom/panopset/blackjackEngine/BlackjackGameState;", "chipDim", "<init>", "(Lcom/panopset/compat/Tile;[ILcom/panopset/blackjackEngine/BlackjackGameState;[I)V", "chipW", "", "getChipW", "()I", "chipH", "getChipH", "value", "playerChipY", "getPlayerChipY", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "playerMsgY", "getPlayerMsgY", "playerCardXstart", "getPlayerCardXstart", "playerY", "getPlayerY", "desk"})
public final class LayoutPlayer
extends Layout {
    private final int chipW;
    private final int chipH;
    @Nullable
    private Integer playerChipY;
    @Nullable
    private Integer playerMsgY;
    @Nullable
    private Integer playerCardXstart;
    @Nullable
    private Integer playerY;

    public LayoutPlayer(@Nullable Tile tile, @Nullable int[] cardDim, @Nullable BlackjackGameState cs, @NotNull int[] chipDim) {
        Intrinsics.checkNotNullParameter(chipDim, "chipDim");
        Tile tile2 = tile;
        Intrinsics.checkNotNull(tile2);
        Intrinsics.checkNotNull(cardDim);
        BlackjackGameState blackjackGameState = cs;
        Intrinsics.checkNotNull(blackjackGameState);
        super(tile2, cardDim, blackjackGameState);
        this.chipW = chipDim[0];
        this.chipH = chipDim[1];
    }

    public final int getChipW() {
        return this.chipW;
    }

    public final int getChipH() {
        return this.chipH;
    }

    @Nullable
    public final Integer getPlayerChipY() {
        if (this.playerChipY == null) {
            this.playerChipY = this.getT().getTop() + this.getCardH();
        }
        return this.playerChipY;
    }

    @Nullable
    public final Integer getPlayerMsgY() {
        if (this.playerMsgY == null) {
            Integer n = this.getPlayerChipY();
            Intrinsics.checkNotNull(n);
            this.playerMsgY = n + this.chipH * 2;
        }
        return this.playerMsgY;
    }

    @Nullable
    public final Integer getPlayerCardXstart() {
        if (this.playerCardXstart == null) {
            int cardsWidth = 0;
            for (Player p : this.getCs().getPlayers()) {
                Iterator<HandPlayer> iterator2;
                Intrinsics.checkNotNullExpressionValue(p.getHands().iterator(), "iterator(...)");
                while (iterator2.hasNext()) {
                    HandPlayer h;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                    if (!(!((Collection)h.getBlackjackCards()).isEmpty())) continue;
                    cardsWidth += this.getCardW();
                    cardsWidth += this.getCardSpacer() * h.getBlackjackCards().size();
                }
            }
            this.playerCardXstart = this.getCenterW() - cardsWidth / 2;
        }
        return this.playerCardXstart;
    }

    @Nullable
    public final Integer getPlayerY() {
        if (this.playerY == null) {
            this.playerY = this.getT().getTop() + this.getCardH();
        }
        return this.playerY;
    }
}

