/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.Hand;
import com.panopset.blackjackEngine.Wager;
import com.panopset.compat.Logz;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001cJ\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rJ\u0006\u0010&\u001a\u00020\u001eJ\u0006\u0010'\u001a\u00020\rJ\u0006\u0010(\u001a\u00020\u001eJ\u0010\u0010)\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0002J\u0006\u0010,\u001a\u00020\rJ\u0006\u0010-\u001a\u00020\u001eJ\u0006\u0010.\u001a\u00020\u001cJ\u0006\u0010/\u001a\u00020\u001cJ\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\rJ\u0006\u00103\u001a\u00020\rJ\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c05J\u0006\u00106\u001a\u00020\rJ\u0006\u00107\u001a\u00020\rJ\u0006\u00108\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001f\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0018\"\u0004\b!\u0010\u001aR\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000eR\u0011\u0010*\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0014\u00109\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u000eR\u0011\u0010:\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000e\u00a8\u0006;"}, d2={"Lcom/panopset/blackjackEngine/HandPlayer;", "", "wager", "Lcom/panopset/blackjackEngine/Wager;", "<init>", "(Lcom/panopset/blackjackEngine/Wager;)V", "handPlayer", "(Lcom/panopset/blackjackEngine/HandPlayer;)V", "getWager", "()Lcom/panopset/blackjackEngine/Wager;", "hand", "Lcom/panopset/blackjackEngine/Hand;", "isSplit", "", "()Z", "setSplit", "(Z)V", "isSurrendered", "setSurrendered", "isSelectedEvenMoney", "setSelectedEvenMoney", "action", "", "getAction", "()Ljava/lang/String;", "setAction", "(Ljava/lang/String;)V", "removeSecondCard", "Lcom/panopset/blackjackEngine/BlackjackCard;", "isNatural21", "", "message", "getMessage", "setMessage", "dealCard", "card", "canDouble", "configIsDoubleAfterSplitAllowed", "surrender", "isBustedOrSurrenderred", "standWithEvenMoney", "isCardFacesSplittable", "isCardFacesSplittableIncludeMessage", "includeMessage", "isBusted", "stand", "getFirstCard", "getSecondCard", "getHandValue", "", "isInitialDeal", "hasCards", "getBlackjackCards", "", "isFinal", "isSoft", "isDone", "isFaceMatch", "isDoubleDowned", "blackjackEngine"})
public final class HandPlayer {
    @NotNull
    private final Wager wager;
    @NotNull
    private final Hand hand;
    private boolean isSplit;
    private boolean isSurrendered;
    private boolean isSelectedEvenMoney;
    @NotNull
    private String action;
    @NotNull
    private String message;

    public HandPlayer(@NotNull Wager wager) {
        Intrinsics.checkNotNullParameter(wager, "wager");
        this.wager = wager;
        this.hand = new Hand();
        this.action = "l";
        this.message = "Please select deal (L).";
    }

    @NotNull
    public final Wager getWager() {
        return this.wager;
    }

    public final boolean isSplit() {
        return this.isSplit;
    }

    public final void setSplit(boolean bl) {
        this.isSplit = bl;
    }

    public final boolean isSurrendered() {
        return this.isSurrendered;
    }

    public final void setSurrendered(boolean bl) {
        this.isSurrendered = bl;
    }

    public final boolean isSelectedEvenMoney() {
        return this.isSelectedEvenMoney;
    }

    public final void setSelectedEvenMoney(boolean bl) {
        this.isSelectedEvenMoney = bl;
    }

    @NotNull
    public final String getAction() {
        return this.action;
    }

    public final void setAction(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.action = string;
    }

    public HandPlayer(@NotNull HandPlayer handPlayer) {
        Intrinsics.checkNotNullParameter(handPlayer, "handPlayer");
        this(new Wager(handPlayer.wager));
        this.isSplit = handPlayer.isSplit;
        this.isSurrendered = handPlayer.isSurrendered;
        this.isSelectedEvenMoney = handPlayer.isSelectedEvenMoney;
        this.hand.setFinal(handPlayer.hand.isFinal());
        this.action = handPlayer.action;
        this.message = handPlayer.message;
        Iterator<BlackjackCard> iterator2 = handPlayer.hand.getIterator();
        ArrayList<BlackjackCard> cardsToAddToHand = new ArrayList<BlackjackCard>();
        while (iterator2.hasNext()) {
            BlackjackCard card = iterator2.next();
            cardsToAddToHand.add(card);
        }
        Iterator iterator3 = cardsToAddToHand.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            BlackjackCard card = (BlackjackCard)iterator4.next();
            this.dealCard(card);
        }
    }

    @NotNull
    public final BlackjackCard removeSecondCard() {
        return this.hand.getCards().remove(1);
    }

    public final boolean isNatural21() {
        return this.isSplit ? false : this.hand.isNatural21();
    }

    public final void setSplit() {
        this.isSplit = true;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.message = string;
    }

    public final void dealCard(@NotNull BlackjackCard card) {
        Intrinsics.checkNotNullParameter(card, "card");
        this.hand.dealCard(card);
        this.message = "";
    }

    public final boolean canDouble(boolean configIsDoubleAfterSplitAllowed) {
        if (!this.hand.isInitialDeal()) {
            return false;
        }
        return this.isSplit ? configIsDoubleAfterSplitAllowed : true;
    }

    public final void surrender() {
        this.isSurrendered = true;
        this.hand.stand();
    }

    public final boolean isBustedOrSurrenderred() {
        return this.hand.isBusted() ? true : this.isSurrendered;
    }

    public final void standWithEvenMoney() {
        this.hand.stand();
        this.isSelectedEvenMoney = true;
    }

    public final boolean isCardFacesSplittable() {
        return this.isCardFacesSplittable(false);
    }

    public final boolean isCardFacesSplittableIncludeMessage() {
        return this.isCardFacesSplittable(true);
    }

    private final boolean isCardFacesSplittable(boolean includeMessage) {
        if (this.hand.getCards().size() != 2) {
            if (includeMessage) {
                Logz.INSTANCE.warn("Can't split a hit hand");
            }
            return false;
        }
        if (!this.isFaceMatch()) {
            if (includeMessage) {
                Logz.INSTANCE.warn("Can't split cards that don't have the same face");
            }
            return false;
        }
        return true;
    }

    public final boolean isBusted() {
        return this.hand.isBusted();
    }

    public final void stand() {
        this.hand.stand();
    }

    @NotNull
    public final BlackjackCard getFirstCard() {
        return this.hand.getCards().get(0);
    }

    @NotNull
    public final BlackjackCard getSecondCard() {
        return this.hand.getCards().get(1);
    }

    public final int getHandValue() {
        return this.hand.getValue();
    }

    public final boolean isInitialDeal() {
        return this.hand.isInitialDeal();
    }

    public final boolean hasCards() {
        return this.hand.hasCards();
    }

    @NotNull
    public final List<BlackjackCard> getBlackjackCards() {
        return this.hand.getCards();
    }

    public final boolean isFinal() {
        return this.hand.isFinal();
    }

    public final boolean isSoft() {
        return this.hand.isSoft();
    }

    public final boolean isDone() {
        return this.hand.isDone();
    }

    private final boolean isFaceMatch() {
        return this.hand.getCards().get(0).getCard().getFace() == this.hand.getCards().get(1).getCard().getFace();
    }

    public final boolean isDoubleDowned() {
        return this.wager.isDoubledDown();
    }
}

