/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/panopset/blackjackEngine/Metrics;", "", "<init>", "()V", "metrics", "(Lcom/panopset/blackjackEngine/Metrics;)V", "mistakeCount", "", "getMistakeCount", "()I", "setMistakeCount", "(I)V", "handCount", "getHandCount", "setHandCount", "handsSinceLastMistake", "getHandsSinceLastMistake", "setHandsSinceLastMistake", "handsSinceLastMistakeRecord", "userDriven", "", "reset", "", "incrementMistakeCount", "setHandsSinceLastMistakeRecord", "value", "getHandsSinceLastMistakeRecord", "reportNewHand", "reportNewHandAutomatic", "blackjackEngine"})
public final class Metrics {
    private int mistakeCount;
    private int handCount;
    private int handsSinceLastMistake;
    private int handsSinceLastMistakeRecord;
    private boolean userDriven;

    public Metrics() {
        this.userDriven = true;
    }

    public final int getMistakeCount() {
        return this.mistakeCount;
    }

    public final void setMistakeCount(int n) {
        this.mistakeCount = n;
    }

    public final int getHandCount() {
        return this.handCount;
    }

    public final void setHandCount(int n) {
        this.handCount = n;
    }

    public final int getHandsSinceLastMistake() {
        return this.handsSinceLastMistake;
    }

    public final void setHandsSinceLastMistake(int n) {
        this.handsSinceLastMistake = n;
    }

    public Metrics(@NotNull Metrics metrics) {
        Intrinsics.checkNotNullParameter(metrics, "metrics");
        this();
        this.mistakeCount = metrics.mistakeCount;
        this.handCount = metrics.handCount;
        this.handsSinceLastMistake = metrics.handsSinceLastMistake;
        this.handsSinceLastMistakeRecord = metrics.handsSinceLastMistakeRecord;
        this.userDriven = metrics.userDriven;
    }

    public final void reset() {
        this.mistakeCount = 0;
        this.handCount = 0;
        this.handsSinceLastMistake = 0;
        this.userDriven = true;
    }

    public final void incrementMistakeCount() {
        int n = this.mistakeCount;
        this.mistakeCount = n + 1;
        this.handsSinceLastMistake = 0;
        this.userDriven = true;
    }

    private final void setHandsSinceLastMistakeRecord(int value) {
        if (!this.userDriven) {
            return;
        }
        if (this.handsSinceLastMistakeRecord < value) {
            this.handsSinceLastMistakeRecord = value;
        }
    }

    public final int getHandsSinceLastMistakeRecord() {
        return this.handsSinceLastMistakeRecord;
    }

    public final void reportNewHand() {
        int n = this.handCount;
        this.handCount = n + 1;
        n = this.handsSinceLastMistake;
        this.handsSinceLastMistake = n + 1;
        this.setHandsSinceLastMistakeRecord(this.handsSinceLastMistake);
    }

    public final void reportNewHandAutomatic() {
        this.userDriven = false;
        this.reportNewHand();
    }
}

