/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.ByFileFilter;
import com.panopset.compat.ByLineFilter;
import com.panopset.compat.ReportFileTransformer;
import com.panopset.compat.Transformer;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/panopset/compat/FileProcessor;", "", "targetFile", "Ljava/io/File;", "isRecursive", "", "<init>", "(Ljava/io/File;Z)V", "transformer", "Lcom/panopset/compat/Transformer;", "getTransformer", "()Lcom/panopset/compat/Transformer;", "byFileFilters", "", "Lcom/panopset/compat/ByFileFilter;", "getByFileFilters", "()Ljava/util/List;", "setByFileFilters", "(Ljava/util/List;)V", "exec", "", "recursiveExec", "rFile", "processFile", "withFileFilter", "byFileFilter", "withLineFilter", "byLineFilter", "Lcom/panopset/compat/ByLineFilter;", "compat"})
public final class FileProcessor {
    @NotNull
    private final File targetFile;
    private final boolean isRecursive;
    @NotNull
    private final Transformer transformer;
    @NotNull
    private List<ByFileFilter> byFileFilters;

    public FileProcessor(@NotNull File targetFile, boolean isRecursive) {
        Intrinsics.checkNotNullParameter(targetFile, "targetFile");
        this.targetFile = targetFile;
        this.isRecursive = isRecursive;
        this.transformer = new Transformer();
        this.byFileFilters = new ArrayList();
    }

    public /* synthetic */ FileProcessor(File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(file, bl);
    }

    @NotNull
    public final Transformer getTransformer() {
        return this.transformer;
    }

    @NotNull
    public final List<ByFileFilter> getByFileFilters() {
        return this.byFileFilters;
    }

    public final void setByFileFilters(@NotNull List<ByFileFilter> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.byFileFilters = list;
    }

    public final void exec() {
        if (this.isRecursive) {
            this.recursiveExec(this.targetFile);
        } else if (this.targetFile.isDirectory()) {
            Iterator<Object> iterator2 = ArrayIteratorKt.iterator((Object[])Objects.requireNonNull(this.targetFile.listFiles()));
            while (iterator2.hasNext()) {
                File f = (File)iterator2.next();
                if (!f.isFile()) continue;
                Intrinsics.checkNotNull(f);
                this.processFile(f);
            }
        } else {
            new ReportFileTransformer(this.targetFile, this.transformer).exec();
        }
    }

    private final void recursiveExec(File rFile) {
        if (rFile.isDirectory()) {
            Iterator<Object> iterator2 = ArrayIteratorKt.iterator((Object[])Objects.requireNonNull(rFile.listFiles()));
            while (iterator2.hasNext()) {
                File f = (File)iterator2.next();
                Intrinsics.checkNotNull(f);
                this.recursiveExec(f);
            }
        } else {
            this.processFile(rFile);
        }
    }

    private final void processFile(File rFile) {
        for (ByFileFilter byFileFilter2 : this.byFileFilters) {
            if (byFileFilter2.fileFilter(rFile)) continue;
            return;
        }
        new ReportFileTransformer(rFile, this.transformer).exec();
    }

    @NotNull
    public final FileProcessor withFileFilter(@NotNull ByFileFilter byFileFilter2) {
        Intrinsics.checkNotNullParameter(byFileFilter2, "byFileFilter");
        this.byFileFilters.add(byFileFilter2);
        return this;
    }

    @NotNull
    public final FileProcessor withLineFilter(@NotNull ByLineFilter byLineFilter) {
        Intrinsics.checkNotNullParameter(byLineFilter, "byLineFilter");
        this.transformer.getByLineFilters().add(byLineFilter);
        return this;
    }
}

