/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/panopset/compat/Randomop;", "", "<init>", "()V", "secureRandom", "Ljava/security/SecureRandom;", "random", "", "min", "max", "nextBytes", "", "bytes", "", "nextInt", "nextLong", "", "getRandomHexString", "", "length", "compat"})
public final class Randomop {
    @NotNull
    public static final Randomop INSTANCE = new Randomop();
    @NotNull
    private static final SecureRandom secureRandom = new SecureRandom();

    private Randomop() {
    }

    public final int random(int min, int max) {
        int n;
        if (min == max) {
            n = min;
        } else {
            int shift = min;
            if (min > max) {
                shift = max;
            }
            n = secureRandom.nextInt((int)(Math.abs((double)(max - min)) + 1.0)) + shift;
        }
        return n;
    }

    public final void nextBytes(@Nullable byte[] bytes) {
        secureRandom.nextBytes(bytes);
    }

    public final int nextInt() {
        return secureRandom.nextInt();
    }

    public final long nextLong() {
        return secureRandom.nextLong();
    }

    @NotNull
    public final String getRandomHexString(int length) {
        StringWriter sw = new StringWriter();
        for (int i = 0; i < length; ++i) {
            String string = "%s";
            Object[] objectArray = new Object[]{this.random(0, 15)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            sw.append(string2);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

