/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.ByLineFilter;
import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.Transformer;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u001f\u0010\f\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/panopset/compat/ReportFileTransformer;", "", "ff", "Ljava/io/File;", "tf", "transformer", "Lcom/panopset/compat/Transformer;", "<init>", "(Ljava/io/File;Ljava/io/File;Lcom/panopset/compat/Transformer;)V", "(Ljava/io/File;Lcom/panopset/compat/Transformer;)V", "getTransformer", "()Lcom/panopset/compat/Transformer;", "withByLineFilters", "byLineFilters", "", "Lcom/panopset/compat/ByLineFilter;", "([Lcom/panopset/compat/ByLineFilter;)Lcom/panopset/compat/ReportFileTransformer;", "exec", "", "execInMemory", "execToFile", "processToWriter", "", "writer", "Ljava/io/Writer;", "compat"})
@SourceDebugExtension(value={"SMAP\nReportFileTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportFileTransformer.kt\ncom/panopset/compat/ReportFileTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ReportFileTransformer {
    @NotNull
    private final File ff;
    @NotNull
    private final File tf;
    @NotNull
    private final Transformer transformer;

    public ReportFileTransformer(@NotNull File ff, @NotNull File tf, @NotNull Transformer transformer) {
        Intrinsics.checkNotNullParameter(ff, "ff");
        Intrinsics.checkNotNullParameter(tf, "tf");
        Intrinsics.checkNotNullParameter(transformer, "transformer");
        this.ff = ff;
        this.tf = tf;
        this.transformer = transformer;
    }

    @NotNull
    public final Transformer getTransformer() {
        return this.transformer;
    }

    public ReportFileTransformer(@NotNull File ff, @NotNull Transformer transformer) {
        Intrinsics.checkNotNullParameter(ff, "ff");
        Intrinsics.checkNotNullParameter(transformer, "transformer");
        this(ff, ff, transformer);
    }

    @NotNull
    public final ReportFileTransformer withByLineFilters(ByLineFilter ... byLineFilters) {
        Intrinsics.checkNotNullParameter(byLineFilters, "byLineFilters");
        for (ByLineFilter lf : byLineFilters) {
            this.transformer.withByLineFilter(lf);
        }
        return this;
    }

    public final void exec() {
        if (Intrinsics.areEqual(this.tf, this.ff)) {
            this.execInMemory();
        } else {
            this.execToFile();
        }
    }

    private final void execInMemory() {
        StringWriter sw = new StringWriter();
        boolean hasChanged = this.processToWriter(sw);
        if (hasChanged) {
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            Fileop.INSTANCE.write(string, this.ff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execToFile() {
        try {
            Closeable closeable = new FileWriter(this.tf);
            Throwable throwable = null;
            try {
                FileWriter fw2 = (FileWriter)closeable;
                boolean bl = false;
                boolean bl2 = this.processToWriter(fw2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            Logz.INSTANCE.errorMsg(this.tf, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processToWriter(Writer writer) {
        boolean changed = false;
        Closeable closeable = new FileReader(this.ff);
        Throwable throwable = null;
        try {
            FileReader fr = (FileReader)closeable;
            boolean bl = false;
            changed = this.transformer.process(fr, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return changed;
    }
}

