/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.Streamop;
import com.panopset.compat.Stringop;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\"\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u00020\u00062\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u00a8\u0006\u0017"}, d2={"Lcom/panopset/compat/Rezop;", "", "<init>", "()V", "textStreamToList", "", "", "inputStream", "Ljava/io/InputStream;", "getPackageResourcePath", "pkg", "Ljava/lang/Package;", "pkg2path", "dotName", "copyTextResourceToFile", "", "clazz", "Ljava/lang/Class;", "resourcePath", "file", "Ljava/io/File;", "fileName", "pkg2resourcePath", "compat"})
public final class Rezop {
    @NotNull
    public static final Rezop INSTANCE = new Rezop();

    private Rezop() {
    }

    @NotNull
    public final List<String> textStreamToList(@Nullable InputStream inputStream) {
        if (inputStream == null) {
            return new ArrayList();
        }
        String lines = Streamop.INSTANCE.getTextFromStream(inputStream);
        return Stringop.INSTANCE.stringToList(lines);
    }

    @NotNull
    public final String getPackageResourcePath(@NotNull Package pkg) {
        Intrinsics.checkNotNullParameter(pkg, "pkg");
        StringWriter sw = new StringWriter();
        sw.append("/");
        String string = pkg.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        sw.append(this.pkg2path(string));
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String pkg2path(@NotNull String dotName) {
        Intrinsics.checkNotNullParameter(dotName, "dotName");
        return StringsKt.replace$default(dotName, ".", "/", false, 4, null);
    }

    public final void copyTextResourceToFile(@NotNull Class<?> clazz, @NotNull String resourcePath, @NotNull File file) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(file, "file");
        InputStream inputStream = clazz.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            Logz.INSTANCE.warn(resourcePath + " not found.");
        } else {
            Fileop.INSTANCE.copyInputStreamToFile(inputStream, file);
        }
    }

    public final void copyTextResourceToFile(@NotNull Class<?> clazz, @NotNull String resourcePath, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        InputStream inputStream = clazz.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            Logz.INSTANCE.warn(resourcePath + " not found.");
        } else {
            Fileop.INSTANCE.copyInputStreamToFile(inputStream, fileName);
        }
    }

    @NotNull
    public final String pkg2resourcePath(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        StringWriter sw = new StringWriter();
        sw.append("/");
        String string = clazz.getPackage().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        sw.append(StringsKt.replace$default(string, ".", "/", false, 4, null));
        sw.append("/");
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }
}

