/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.games.bj;

import com.panopset.blackjackEngine.BlackjackConfigDefault;
import com.panopset.compat.Stringop;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanChoiceBox;
import com.panopset.fxapp.PanComponentFactory;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0011\u0010\"\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0011\u0010$\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001dR\u0011\u0010&\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u0011\u0010(\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010-R\u0011\u00100\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010-R\u0011\u00102\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010-R\u0011\u00104\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010-R\u0011\u00106\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010-R\u0011\u00108\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010-R\u0011\u0010:\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010-R\u0011\u0010<\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010-R\u0011\u0010>\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010-R\u0011\u0010@\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010-R\u0011\u0010B\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001d\u00a8\u0006D"}, d2={"Lcom/panopset/desk/games/bj/BlackjackFxControls;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "defaultConfig", "Lcom/panopset/blackjackEngine/BlackjackConfigDefault;", "getDefaultConfig", "()Lcom/panopset/blackjackEngine/BlackjackConfigDefault;", "felt", "Ljavafx/scene/canvas/Canvas;", "getFelt", "()Ljavafx/scene/canvas/Canvas;", "taBasicStrategy", "Ljavafx/scene/control/TextArea;", "getTaBasicStrategy", "()Ljavafx/scene/control/TextArea;", "taCountingSystems", "getTaCountingSystems", "chCountingSystems", "Lcom/panopset/fxapp/PanChoiceBox;", "getChCountingSystems", "()Lcom/panopset/fxapp/PanChoiceBox;", "countPositive", "Ljavafx/scene/control/TextField;", "getCountPositive", "()Ljavafx/scene/control/TextField;", "minimumBet", "getMinimumBet", "incrementBet", "getIncrementBet", "largeBet", "getLargeBet", "targetStake", "getTargetStake", "chDecks", "getChDecks", "chSeats", "getChSeats", "ruleEuropeanStyle", "Ljavafx/scene/control/CheckBox;", "getRuleEuropeanStyle", "()Ljavafx/scene/control/CheckBox;", "resplitAces", "getResplitAces", "splitAcePlayable", "getSplitAcePlayable", "ruleVariations", "getRuleVariations", "dealerHitsSoft17", "getDealerHitsSoft17", "ruleShowCount", "getRuleShowCount", "rule65", "getRule65", "ruleEvenMoney", "getRuleEvenMoney", "doubleAfterSplit", "getDoubleAfterSplit", "ruleLateSurrender", "getRuleLateSurrender", "ruleFastDeal", "getRuleFastDeal", "reloadAmount", "getReloadAmount", "desk"})
public final class BlackjackFxControls {
    @NotNull
    private final FxDoc fxDoc;
    @NotNull
    private final BlackjackConfigDefault defaultConfig;
    @NotNull
    private final Canvas felt;
    @NotNull
    private final TextArea taBasicStrategy;
    @NotNull
    private final TextArea taCountingSystems;
    @NotNull
    private final PanChoiceBox chCountingSystems;
    @NotNull
    private final TextField countPositive;
    @NotNull
    private final TextField minimumBet;
    @NotNull
    private final TextField incrementBet;
    @NotNull
    private final TextField largeBet;
    @NotNull
    private final TextField targetStake;
    @NotNull
    private final PanChoiceBox chDecks;
    @NotNull
    private final PanChoiceBox chSeats;
    @NotNull
    private final CheckBox ruleEuropeanStyle;
    @NotNull
    private final CheckBox resplitAces;
    @NotNull
    private final CheckBox splitAcePlayable;
    @NotNull
    private final CheckBox ruleVariations;
    @NotNull
    private final CheckBox dealerHitsSoft17;
    @NotNull
    private final CheckBox ruleShowCount;
    @NotNull
    private final CheckBox rule65;
    @NotNull
    private final CheckBox ruleEvenMoney;
    @NotNull
    private final CheckBox doubleAfterSplit;
    @NotNull
    private final CheckBox ruleLateSurrender;
    @NotNull
    private final CheckBox ruleFastDeal;
    @NotNull
    private final TextField reloadAmount;

    public BlackjackFxControls(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
        this.defaultConfig = new BlackjackConfigDefault();
        this.felt = new Canvas();
        this.taBasicStrategy = PanComponentFactory.INSTANCE.createPersistentPanTextArea(this.fxDoc, "taBasic", "", "", Stringop.INSTANCE.arrayToString(this.defaultConfig.getStrategyData()));
        this.taCountingSystems = PanComponentFactory.INSTANCE.createPersistentPanTextArea(this.fxDoc, "taCountingSystems", "Reset game to pick up changes.", "Entry with the * in front of the name, is the default.", Stringop.INSTANCE.arrayToString(this.defaultConfig.getCountingSystems().getCountingSystemsData()));
        this.chCountingSystems = PanComponentFactory.INSTANCE.createPanChoiceBox(this.fxDoc, "cb_counting_systems", this.defaultConfig.getCountingSystems().getKeyNames(), this.defaultConfig.getCountingSystems().getDefaultKey());
        this.countPositive = PanComponentFactory.INSTANCE.createPanInputTextFieldWithDefaultValue(this.fxDoc, "count_positive", String.valueOf(this.defaultConfig.getStrategicVeryPositiveCount()), "", "");
        this.minimumBet = PanComponentFactory.INSTANCE.createPanInputTextFieldWithDefaultValue(this.fxDoc, "minimum_bet", String.valueOf(this.defaultConfig.getMinimumBetInWholeDollars()), "", "");
        this.incrementBet = PanComponentFactory.INSTANCE.createPanInputTextFieldWithDefaultValue(this.fxDoc, "increment_bet", String.valueOf(this.defaultConfig.getBetIncrementInWholeDollars()), "", "");
        this.largeBet = PanComponentFactory.INSTANCE.createPanInputTextFieldWithDefaultValue(this.fxDoc, "large_bet", String.valueOf(this.defaultConfig.getLargeBetInWholeDollars()), "", "");
        this.targetStake = PanComponentFactory.INSTANCE.createPanInputTextFieldWithDefaultValue(this.fxDoc, "target_stake", String.valueOf(this.defaultConfig.getTargetStakeInWholeDollars()), "", "");
        String[] stringArray = new String[]{"1", "2", "6", "8"};
        this.chDecks = PanComponentFactory.INSTANCE.createPanChoiceBox(this.fxDoc, "cb_decks", Stringop.INSTANCE.listToArrayList(CollectionsKt.listOf(stringArray)), String.valueOf(this.defaultConfig.getDecks()));
        stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7"};
        this.chSeats = PanComponentFactory.INSTANCE.createPanChoiceBox(this.fxDoc, "cb_seats", Stringop.INSTANCE.listToArrayList(CollectionsKt.listOf(stringArray)), String.valueOf(this.defaultConfig.getSeats()));
        this.ruleEuropeanStyle = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_ls", "European Style.", "Player always loses to dealer Blackjack, even in a push.", this.defaultConfig.isEuropeanStyle());
        this.resplitAces = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rspltaces", "Re-split Aces", "Re-split aces is very hard to find these days.", this.defaultConfig.isResplitAcesAllowed());
        this.splitAcePlayable = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "spltaceplays", "Split Ace playable", "", this.defaultConfig.isSplitAcePlayable());
        this.ruleVariations = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_vs", "Variations.", "", this.defaultConfig.isBasicStrategyVariationsOnly());
        this.dealerHitsSoft17 = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "dealer_hits_soft_17", "Dealer hits soft 17.", "", this.defaultConfig.isDealerHitSoft17());
        this.ruleShowCount = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_sc", "Show count.", "", this.defaultConfig.isShowCount());
        this.rule65 = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_65", "Blackjack pays 6 to 5.", "Blackjack pays 6 to 5 instead of 3 to 2", this.defaultConfig.isBlackjack6to5());
        this.ruleEvenMoney = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_even", "Player takes even money, blackjack versus ace.", "All the books say this is a bad idea.", this.defaultConfig.isEvenMoneyOnBlackjackVace());
        this.doubleAfterSplit = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "dblaftrsplit", "Double after split", "", this.defaultConfig.isDoubleAfterSplitAllowed());
        this.ruleLateSurrender = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_ls", "Late surrender.", "", this.defaultConfig.isLateSurrenderAllowed());
        this.ruleFastDeal = PanComponentFactory.INSTANCE.createPanCheckBox(this.fxDoc, "rule_fd", "Fast deal.", "Skip showing hand result and just go to the next deal.  Having this option, by the way, is the whole reason I wrote this game.", this.defaultConfig.isFastDeal());
        this.reloadAmount = PanComponentFactory.INSTANCE.createPanInputTextFieldWithDefaultValue(this.fxDoc, "reload_amount", String.valueOf(this.defaultConfig.getReloadAmountInWholeDollars()), "Enter your initial stake.", "Initial stake, and reload amount, in dollars.");
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final BlackjackConfigDefault getDefaultConfig() {
        return this.defaultConfig;
    }

    @NotNull
    public final Canvas getFelt() {
        return this.felt;
    }

    @NotNull
    public final TextArea getTaBasicStrategy() {
        return this.taBasicStrategy;
    }

    @NotNull
    public final TextArea getTaCountingSystems() {
        return this.taCountingSystems;
    }

    @NotNull
    public final PanChoiceBox getChCountingSystems() {
        return this.chCountingSystems;
    }

    @NotNull
    public final TextField getCountPositive() {
        return this.countPositive;
    }

    @NotNull
    public final TextField getMinimumBet() {
        return this.minimumBet;
    }

    @NotNull
    public final TextField getIncrementBet() {
        return this.incrementBet;
    }

    @NotNull
    public final TextField getLargeBet() {
        return this.largeBet;
    }

    @NotNull
    public final TextField getTargetStake() {
        return this.targetStake;
    }

    @NotNull
    public final PanChoiceBox getChDecks() {
        return this.chDecks;
    }

    @NotNull
    public final PanChoiceBox getChSeats() {
        return this.chSeats;
    }

    @NotNull
    public final CheckBox getRuleEuropeanStyle() {
        return this.ruleEuropeanStyle;
    }

    @NotNull
    public final CheckBox getResplitAces() {
        return this.resplitAces;
    }

    @NotNull
    public final CheckBox getSplitAcePlayable() {
        return this.splitAcePlayable;
    }

    @NotNull
    public final CheckBox getRuleVariations() {
        return this.ruleVariations;
    }

    @NotNull
    public final CheckBox getDealerHitsSoft17() {
        return this.dealerHitsSoft17;
    }

    @NotNull
    public final CheckBox getRuleShowCount() {
        return this.ruleShowCount;
    }

    @NotNull
    public final CheckBox getRule65() {
        return this.rule65;
    }

    @NotNull
    public final CheckBox getRuleEvenMoney() {
        return this.ruleEvenMoney;
    }

    @NotNull
    public final CheckBox getDoubleAfterSplit() {
        return this.doubleAfterSplit;
    }

    @NotNull
    public final CheckBox getRuleLateSurrender() {
        return this.ruleLateSurrender;
    }

    @NotNull
    public final CheckBox getRuleFastDeal() {
        return this.ruleFastDeal;
    }

    @NotNull
    public final TextField getReloadAmount() {
        return this.reloadAmount;
    }
}

