/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.games.bj;

import com.panopset.blackjackEngine.DefaultResources;
import com.panopset.compat.Stringop;
import com.panopset.desk.games.bj.BlackjackFxControls;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.PanComponentFactory;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/panopset/desk/games/bj/TabConfigCounting;", "", "ctls", "Lcom/panopset/desk/games/bj/BlackjackFxControls;", "<init>", "(Lcom/panopset/desk/games/bj/BlackjackFxControls;)V", "getCtls", "()Lcom/panopset/desk/games/bj/BlackjackFxControls;", "createTab", "Ljavafx/scene/control/Tab;", "userReset", "", "defaultCountingSystems", "", "desk"})
public final class TabConfigCounting {
    @NotNull
    private final BlackjackFxControls ctls;
    @NotNull
    private final String defaultCountingSystems;

    public TabConfigCounting(@NotNull BlackjackFxControls ctls) {
        Intrinsics.checkNotNullParameter(ctls, "ctls");
        this.ctls = ctls;
        this.defaultCountingSystems = new DefaultResources().getDefaultCountingSystems();
    }

    @NotNull
    public final BlackjackFxControls getCtls() {
        return this.ctls;
    }

    @NotNull
    public final Tab createTab() {
        Tab rtn2 = FontManagerFX.INSTANCE.registerTab(this.ctls.getFxDoc(), new Tab("Counting"));
        Node[] nodeArray = new Node[2];
        Node[] nodeArray2 = new Node[5];
        nodeArray2[0] = PanComponentFactory.INSTANCE.createPanTitledPane(this.ctls.getFxDoc(), "Counting system", this.ctls.getChCountingSystems().getChoiceBoxForDisplayOnly());
        nodeArray2[1] = PanComponentFactory.INSTANCE.createPanTitledPane(this.ctls.getFxDoc(), "Positive count large bet trigger", this.ctls.getCountPositive());
        nodeArray2[2] = PanComponentFactory.INSTANCE.createPanLabel(this.ctls.getFxDoc(), "Setting positive count trigger to 0, or blank, will turn off card counting adjustments.");
        nodeArray2[3] = PanComponentFactory.INSTANCE.createPanLabel(this.ctls.getFxDoc(), "Counting system simulations work best with one player.");
        Node[] nodeArray3 = new Node[]{PanComponentFactory.INSTANCE.createPanButton(this.ctls.getFxDoc(), () -> TabConfigCounting.createTab$lambda$0(this), "Reset to default.", false, ""), PanComponentFactory.INSTANCE.createPanLabel(this.ctls.getFxDoc(), "  Counting systems:")};
        nodeArray2[4] = PanComponentFactory.INSTANCE.createPanFlowPane(nodeArray3);
        nodeArray[0] = PanComponentFactory.INSTANCE.createPanVBox(nodeArray2);
        nodeArray2 = new Node[]{PanComponentFactory.INSTANCE.createPanTitledPane(this.ctls.getFxDoc(), "Minimum Bet", this.ctls.getMinimumBet()), PanComponentFactory.INSTANCE.createPanTitledPane(this.ctls.getFxDoc(), "Large Bet", this.ctls.getLargeBet()), PanComponentFactory.INSTANCE.createPanTitledPane(this.ctls.getFxDoc(), "Target Stake", this.ctls.getTargetStake())};
        nodeArray[1] = PanComponentFactory.INSTANCE.createPanVBox(nodeArray2);
        HBox topHbox = PanComponentFactory.INSTANCE.createPanHBox(nodeArray);
        topHbox.setSpacing(5.0);
        this.ctls.getTaCountingSystems().setText(this.defaultCountingSystems);
        BorderPane bp = new BorderPane();
        bp.setTop(topHbox);
        bp.setCenter(PanComponentFactory.INSTANCE.createPanScrollPane(this.ctls.getTaCountingSystems()));
        rtn2.setContent(bp);
        String countingSystemsText = this.ctls.getTaCountingSystems().getText();
        if (!Stringop.INSTANCE.isPopulated(countingSystemsText)) {
            this.userReset(this.ctls);
        }
        return rtn2;
    }

    private final void userReset(BlackjackFxControls ctls) {
        ctls.getTaCountingSystems().setText(this.defaultCountingSystems);
    }

    private static final Unit createTab$lambda$0(TabConfigCounting this$0) {
        this$0.userReset(this$0.ctls);
        return Unit.INSTANCE;
    }
}

