/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.SourceFile;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateDirectiveCommand;
import com.panopset.flywheel.TemplateLine;
import com.panopset.flywheel.TemplateSource;
import java.io.StringWriter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/panopset/flywheel/CommandTplt;", "Lcom/panopset/flywheel/TemplateDirectiveCommand;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "innerPiece", "", "template", "Lcom/panopset/flywheel/Template;", "<init>", "(Lcom/panopset/flywheel/TemplateLine;Ljava/lang/String;Lcom/panopset/flywheel/Template;)V", "lastCommand", "Lcom/panopset/flywheel/Command;", "getLastCommand", "()Lcom/panopset/flywheel/Command;", "setLastCommand", "(Lcom/panopset/flywheel/Command;)V", "resolve", "", "sw", "Ljava/io/StringWriter;", "Companion", "flywheel"})
public final class CommandTplt
extends TemplateDirectiveCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Command lastCommand;

    public CommandTplt(@NotNull TemplateLine templateLine, @NotNull String innerPiece, @NotNull Template template) {
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        Intrinsics.checkNotNullParameter(innerPiece, "innerPiece");
        Intrinsics.checkNotNullParameter(template, "template");
        super(templateLine, innerPiece, template);
    }

    @Nullable
    public final Command getLastCommand() {
        return this.lastCommand;
    }

    public final void setLastCommand(@Nullable Command command) {
        this.lastCommand = command;
    }

    @Override
    public void resolve(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        TemplateSource ts = this.getTemplate().getTemplateSource();
        String templateFileName = this.mapValueFirstThenExplicit(this.getParams());
        String string = "Template %s executing template %s at line %4d.";
        Object[] objectArray = new Object[]{ts.getName(), templateFileName, ts.getLine()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Logz.INSTANCE.info(string2);
        Template template = new Template(this.getTemplate().getFlywheel(), new SourceFile(this.getTemplate().getFlywheel(), templateFileName), this.getTemplate().getTemplateRules());
        template.exec(sw);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/panopset/flywheel/CommandTplt$Companion;", "", "<init>", "()V", "shortHtmlText", "", "getShortHtmlText", "()Ljava/lang/String;", "flywheel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShortHtmlText() {
            return "${&#064;t someTemplateFile.txt}";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

