/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Stringop;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateCommand;
import com.panopset.flywheel.TemplateLine;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/panopset/flywheel/CommandVariable;", "Lcom/panopset/flywheel/TemplateCommand;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "innerPiece", "", "template", "Lcom/panopset/flywheel/Template;", "<init>", "(Lcom/panopset/flywheel/TemplateLine;Ljava/lang/String;Lcom/panopset/flywheel/Template;)V", "resolve", "", "sw", "Ljava/io/StringWriter;", "resolveCombiner", "combineStr", "CombineLineManager", "Companion", "flywheel"})
public final class CommandVariable
extends TemplateCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandVariable(@NotNull TemplateLine templateLine, @NotNull String innerPiece, @NotNull Template template) {
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        Intrinsics.checkNotNullParameter(innerPiece, "innerPiece");
        Intrinsics.checkNotNullParameter(template, "template");
        super(templateLine, innerPiece, template);
        this.setParms(innerPiece);
    }

    @Override
    public void resolve(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        String combineStr = this.getTemplate().getFlywheel().getCombine();
        if (Stringop.INSTANCE.isPopulated(combineStr) && Intrinsics.areEqual("l", this.getParams())) {
            this.resolveCombiner(sw, combineStr);
            return;
        }
        String parms = this.getParams();
        if (Stringop.INSTANCE.isPopulated(parms)) {
            if (Intrinsics.areEqual(parms, "com.panopset.flywheel.template")) {
                v0 = sw.append(this.getTemplate().getRelativePath());
            } else {
                List<String> findLines;
                String tmplt = this.getTemplate().getFlywheel().getEntry(this.getParams());
                if (!this.getTemplate().getFlywheel().isReplacementsSuppressed()) {
                    Iterator<String[]> iterator2 = this.getTemplate().getFlywheel().getReplacements().iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                    Iterator<String[]> iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        String[] s;
                        Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                        tmplt = StringsKt.replace$default(tmplt, s[0], s[1], false, 4, null);
                    }
                }
                if ((findLines = this.getTemplate().getFlywheel().getFindLines()).isEmpty()) {
                    v0 = sw.append(tmplt);
                } else {
                    for (String fl : findLines) {
                        if (!Stringop.INSTANCE.isPopulated(fl) || StringsKt.indexOf$default((CharSequence)tmplt, fl, 0, false, 6, null) <= -1) continue;
                        sw.append(tmplt);
                    }
                    v0 = Unit.INSTANCE;
                }
            }
        }
    }

    private final void resolveCombiner(StringWriter sw, String combineStr) {
        int combineLines = Stringop.INSTANCE.parseInt(combineStr);
        if (combineLines > 0) {
            CombineLineManager.INSTANCE.combine(sw, combineLines, this.getTemplate().getFlywheel().getEntry(this.getParams()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010j\u0002\b\u0004\u00a8\u0006\u0017"}, d2={"Lcom/panopset/flywheel/CommandVariable$CombineLineManager;", "", "<init>", "(Ljava/lang/String;I)V", "INSTANCE", "assembledValue", "Ljava/io/StringWriter;", "getAssembledValue", "()Ljava/io/StringWriter;", "setAssembledValue", "(Ljava/io/StringWriter;)V", "currentCombine", "", "getCurrentCombine", "()I", "setCurrentCombine", "(I)V", "combine", "", "sw", "combineLines", "value", "", "flywheel"})
    private static final class CombineLineManager
    extends Enum<CombineLineManager> {
        @NotNull
        private StringWriter assembledValue = new StringWriter();
        private int currentCombine;
        public static final /* enum */ CombineLineManager INSTANCE = new CombineLineManager();
        private static final /* synthetic */ CombineLineManager[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final StringWriter getAssembledValue() {
            return this.assembledValue;
        }

        public final void setAssembledValue(@NotNull StringWriter stringWriter) {
            Intrinsics.checkNotNullParameter(stringWriter, "<set-?>");
            this.assembledValue = stringWriter;
        }

        public final int getCurrentCombine() {
            return this.currentCombine;
        }

        public final void setCurrentCombine(int n) {
            this.currentCombine = n;
        }

        public final void combine(@NotNull StringWriter sw, int combineLines, @Nullable String value) {
            Intrinsics.checkNotNullParameter(sw, "sw");
            this.assembledValue.append(value);
            ++this.currentCombine;
            if (this.currentCombine == combineLines) {
                sw.append(this.assembledValue.toString());
                this.assembledValue = new StringWriter();
                this.currentCombine = 0;
            }
        }

        public static CombineLineManager[] values() {
            return (CombineLineManager[])$VALUES.clone();
        }

        public static CombineLineManager valueOf(String value) {
            return Enum.valueOf(CombineLineManager.class, value);
        }

        @NotNull
        public static EnumEntries<CombineLineManager> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = combineLineManagerArray = new CombineLineManager[]{CombineLineManager.INSTANCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/panopset/flywheel/CommandVariable$Companion;", "", "<init>", "()V", "shortHtmlText", "", "getShortHtmlText", "()Ljava/lang/String;", "flywheel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShortHtmlText() {
            return "${variableName}";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

