/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.Fileop;
import com.panopset.compat.Stringop;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.JavaFXapp;
import com.panopset.fxapp.PanComponentFactory;
import java.io.File;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0006\u0010\u0018\u001a\u00020\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/panopset/fxapp/PanFileOrDirSelectorPanel;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "fxId", "", "<init>", "(Lcom/panopset/fxapp/FxDoc;Ljava/lang/String;)V", "createFile", "Ljava/io/File;", "isRecursive", "", "inputFile", "Ljavafx/scene/control/TextField;", "pane", "Ljavafx/scene/layout/HBox;", "getPane", "()Ljavafx/scene/layout/HBox;", "recursiveCheckBox", "Ljavafx/scene/control/CheckBox;", "triggerUpdate", "", "getInitialDirectoryFrom", "path", "isPopulated", "fxapp"})
public final class PanFileOrDirSelectorPanel {
    @NotNull
    private final TextField inputFile;
    @NotNull
    private final HBox pane;
    @NotNull
    private final CheckBox recursiveCheckBox;

    public PanFileOrDirSelectorPanel(@NotNull FxDoc fxDoc, @NotNull String fxId) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(fxId, "fxId");
        this.inputFile = PanComponentFactory.INSTANCE.createPanInputTextFieldHGrow(fxDoc, fxId, "Please select a file or directory.", "Selected file or directory full path.");
        this.pane = new HBox();
        this.recursiveCheckBox = PanComponentFactory.INSTANCE.createPanCheckBox(fxDoc, fxId + "_isRecursive", "Recursive ", "Traverse subdirectories of selected directory.");
        this.inputFile.textProperty().addListener((arg_0, arg_1, arg_2) -> PanFileOrDirSelectorPanel._init_$lambda$1((arg_0, arg_1, arg_2) -> PanFileOrDirSelectorPanel._init_$lambda$0(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.recursiveCheckBox.setSelected(true);
        this.pane.getChildren().add(PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> PanFileOrDirSelectorPanel._init_$lambda$2(this), "Directory", false, "Select directory"));
        this.pane.getChildren().add(PanComponentFactory.INSTANCE.createPanButton(fxDoc, () -> PanFileOrDirSelectorPanel._init_$lambda$3(this), "File", false, "Select file."));
        this.pane.getChildren().add(this.recursiveCheckBox);
        HBox.setHgrow(this.pane, Priority.ALWAYS);
        this.pane.getChildren().add(this.inputFile);
        PanComponentFactory.INSTANCE.decorateFileInputTextForMouse(this.inputFile);
    }

    @NotNull
    public final File createFile() {
        return new File(this.inputFile.getText());
    }

    public final boolean isRecursive() {
        return this.recursiveCheckBox.isSelected();
    }

    @NotNull
    public final HBox getPane() {
        return this.pane;
    }

    private final void triggerUpdate() {
        File fileChecker = this.createFile();
        this.recursiveCheckBox.visibleProperty().setValue(fileChecker.isDirectory() && fileChecker.exists());
    }

    private final File getInitialDirectoryFrom(String path) {
        File oldFile;
        String string = this.inputFile.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (((CharSequence)string).length() > 0 && (oldFile = new File(path)).exists()) {
            File file;
            if (oldFile.isFile()) {
                File file2 = oldFile.getParentFile();
                Intrinsics.checkNotNull(file2);
                file = file2;
            } else {
                file = oldFile;
            }
            return file;
        }
        return new File(Stringop.INSTANCE.getUSH());
    }

    public final boolean isPopulated() {
        String string = this.inputFile.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return ((CharSequence)string).length() > 0;
    }

    private static final Unit _init_$lambda$0(PanFileOrDirSelectorPanel this$0, ObservableValue observableValue, String string, String string2) {
        this$0.triggerUpdate();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke(p0, p1, p2);
    }

    private static final Unit _init_$lambda$2(PanFileOrDirSelectorPanel this$0) {
        DirectoryChooser dc = new DirectoryChooser();
        String string = this$0.inputFile.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        dc.setInitialDirectory(this$0.getInitialDirectoryFrom(string));
        File file = dc.showDialog(JavaFXapp.INSTANCE.findStage());
        if (file.exists() && file.isDirectory()) {
            this$0.inputFile.setText(Fileop.INSTANCE.getCanonicalPath(file));
            this$0.inputFile.setTooltip(new Tooltip("Selected directory full path."));
            this$0.recursiveCheckBox.visibleProperty().setValue(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(PanFileOrDirSelectorPanel this$0) {
        FileChooser fc = new FileChooser();
        String string = this$0.inputFile.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        fc.setInitialDirectory(this$0.getInitialDirectoryFrom(string));
        File file = fc.showOpenDialog(JavaFXapp.INSTANCE.findStage());
        if (file.exists() && file.isFile()) {
            this$0.inputFile.setText(Fileop.INSTANCE.getCanonicalPath(file));
            this$0.inputFile.setTooltip(new Tooltip("Selected file full path."));
            this$0.recursiveCheckBox.visibleProperty().setValue(false);
        }
        return Unit.INSTANCE;
    }
}

