/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.games.blackjack;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.BlackjackGameState;
import com.panopset.blackjackEngine.Card;
import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Player;
import com.panopset.compat.Stringop;
import com.panopset.compat.Tile;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.marin.game.card.images.BlackjackImages;
import com.panopset.marin.games.blackjack.FeltPainterKt;
import com.panopset.marin.oldswpkg.games.blackjack.BlackjackCmdBinder;
import com.panopset.marin.oldswpkg.games.blackjack.BlackjackTable;
import com.panopset.marin.oldswpkg.games.blackjack.FxCardPainter;
import com.panopset.marin.oldswpkg.games.blackjack.FxChipPainter;
import com.panopset.marin.oldswpkg.games.blackjack.LayoutChips;
import com.panopset.marin.oldswpkg.games.blackjack.LayoutDealer;
import com.panopset.marin.oldswpkg.games.blackjack.LayoutPlayer;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J \u0010 \u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J \u0010$\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010&\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010-\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/panopset/marin/games/blackjack/FeltPainter;", "", "<init>", "()V", "updateTable", "", "w", "", "h", "chpptr", "Lcom/panopset/marin/oldswpkg/games/blackjack/FxChipPainter;", "cptr", "Lcom/panopset/marin/oldswpkg/games/blackjack/FxCardPainter;", "verticalSeparator", "lastWidth", "lastHeight", "blackjackTable", "Lcom/panopset/marin/oldswpkg/games/blackjack/BlackjackTable;", "draw", "cs", "Lcom/panopset/blackjackEngine/BlackjackGameState;", "g", "Ljavafx/scene/canvas/GraphicsContext;", "width", "height", "paintMsgLandscape", "t", "Lcom/panopset/compat/Tile;", "initGforMsg", "paintMistakeMessage", "y", "vs", "paintKeyMeanings", "x", "commander", "Lcom/panopset/marin/oldswpkg/games/blackjack/BlackjackCmdBinder;", "paintDealer", "paintPlayer", "paintStatus", "dbg", "", "getDbg", "()Z", "setDbg", "(Z)V", "paintChips", "font0", "Ljavafx/scene/text/Font;", "font1", "fontMono", "desk"})
@SourceDebugExtension(value={"SMAP\nFeltPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeltPainter.kt\ncom/panopset/marin/games/blackjack/FeltPainter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,243:1\n1#2:244\n108#3:245\n80#3,22:246\n108#3:268\n80#3,22:269\n*S KotlinDebug\n*F\n+ 1 FeltPainter.kt\ncom/panopset/marin/games/blackjack/FeltPainter\n*L\n199#1:245\n199#1:246,22\n230#1:268\n230#1:269,22\n*E\n"})
public final class FeltPainter {
    @NotNull
    private FxChipPainter chpptr = new FxChipPainter();
    @NotNull
    private FxCardPainter cptr = new FxCardPainter();
    private int verticalSeparator;
    private int lastWidth = 600;
    private int lastHeight = 500;
    @NotNull
    private BlackjackTable blackjackTable = new BlackjackTable(600, 500, this.cptr.getCardHeight());
    @NotNull
    private final BlackjackCmdBinder commander = new BlackjackCmdBinder();
    private boolean dbg;
    @NotNull
    private final Font font0 = FontManagerFX.INSTANCE.getPlainSerif();
    @NotNull
    private final Font font1 = FontManagerFX.INSTANCE.getBoldSerif();
    @NotNull
    private final Font fontMono = FontManagerFX.INSTANCE.getMonospace();

    private final void updateTable(int w, int h) {
        if (FeltPainterKt.weDoNotHaveEnoughRoomToWorkWith(w, h)) {
            return;
        }
        this.blackjackTable = new BlackjackTable(w, h, this.cptr.getCardHeight());
    }

    public final void draw(@NotNull BlackjackGameState cs, @NotNull GraphicsContext g, int width, int height) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        Intrinsics.checkNotNullParameter(g, "g");
        if ((double)width == 0.0 || (double)height == 0.0) {
            return;
        }
        if (width != this.lastWidth || height != this.lastHeight) {
            this.updateTable(width, height);
            this.lastWidth = width;
            this.lastHeight = height;
        }
        this.verticalSeparator = (int)((double)FontManagerFX.INSTANCE.getSize() * 1.2);
        if (Stringop.INSTANCE.isPopulated(cs.getMistakeMessage())) {
            g.setFill(Color.DARKRED);
        } else {
            g.setFill(Color.DARKGREEN);
        }
        g.fillRect(0.0, 0.0, width, height);
        this.paintChips(g, this.blackjackTable.getChipTray(), cs);
        this.paintDealer(g, this.blackjackTable.getDealerTile(), cs);
        if (this.dbg) {
            g.setFill(Color.YELLOW);
            Tile pt = this.blackjackTable.getPlayerTile();
            g.fillRect(pt.getLeft(), pt.getTop(), pt.getWidth(), pt.getBottom());
            g.setFill(Color.GRAY);
            Tile mt = this.blackjackTable.getMsgTile();
            g.fillRect(mt.getLeft(), mt.getTop(), mt.getWidth(), mt.getBottom());
        }
        this.paintPlayer(g, this.blackjackTable.getPlayerTile(), cs);
        this.paintMsgLandscape(cs, g, this.blackjackTable.getMsgTile());
    }

    private final void paintMsgLandscape(BlackjackGameState cs, GraphicsContext g, Tile t) {
        this.initGforMsg(cs, g, t);
        int y = t.getBottom() - this.verticalSeparator / 2;
        this.paintMistakeMessage(cs, g, t, y, this.verticalSeparator);
    }

    private final void initGforMsg(BlackjackGameState cs, GraphicsContext g, Tile t) {
        g.setFill(Color.BLACK);
        g.setFont(this.font0);
        if (Stringop.INSTANCE.isPopulated(cs.getMistakeMessage())) {
            g.setFill(Color.YELLOW);
        } else {
            g.setFill(Color.DARKBLUE);
        }
        g.setFont(this.font0);
    }

    private final void paintMistakeMessage(BlackjackGameState cs, GraphicsContext g, Tile t, int y, int vs) {
        if (Stringop.INSTANCE.isPopulated(cs.getMistakeMessage())) {
            g.setFill(Color.YELLOW);
            g.setFont(Font.font("Monospaced", FontManagerFX.INSTANCE.getSize()));
            String string = "%s - dealer up card.";
            Object[] objectArray = new Object[]{cs.getMistakeHeader()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            g.fillText(string2, 0.0, y);
            string = "%s - basic strategy line for your hand.";
            objectArray = new Object[]{cs.getMistakeMessage()};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            g.fillText(string3, 0.0, y + vs);
            g.setFont(this.font0);
        } else if (Stringop.INSTANCE.isPopulated(cs.getDealerMessage())) {
            g.setFill(Color.WHITE);
            g.fillText(cs.getDealerMessage(), 0.0, y);
        }
        int newY = y - vs;
        this.paintKeyMeanings(g, t.getLeft(), newY);
    }

    private final void paintKeyMeanings(GraphicsContext g, int x, int y) {
        g.setFont(this.font0);
        g.setFill(Color.LIGHTYELLOW);
        g.fillText(this.commander.toString(), x, y);
    }

    private final void paintDealer(GraphicsContext g, Tile t, BlackjackGameState cs) {
        if (this.dbg) {
            g.setFill(Color.RED);
            g.fillRect(t.getLeft(), t.getTop(), t.getWidth(), t.getBottom());
        }
        int[] nArray = new int[]{this.cptr.getCardWidth(), this.cptr.getCardHeight()};
        LayoutDealer o = new LayoutDealer(t, nArray, cs);
        g.setFill(Color.BLACK);
        for (BlackjackCard bc : cs.getHandDealer().getCards()) {
            Integer n = o.getNextDealerX();
            if (n == null) continue;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.cptr.paintCard(g, bc.getCard(), it, 0);
        }
    }

    private final void paintPlayer(GraphicsContext g, Tile t, BlackjackGameState cs) {
        g.setFill(Color.BLACK);
        int[] nArray = new int[]{this.cptr.getCardWidth(), this.cptr.getCardHeight()};
        int[] nArray2 = nArray;
        nArray = new int[]{this.chpptr.getChipWidth(), this.chpptr.getChipHeight()};
        LayoutPlayer o = new LayoutPlayer(t, nArray2, cs, nArray);
        Integer n = o.getPlayerCardXstart();
        Intrinsics.checkNotNull(n);
        int cardX = n;
        boolean arrowHasBeenDrawn = false;
        for (Player p : cs.getPlayers()) {
            Iterator<HandPlayer> iterator2;
            HandPlayer activeHand = p.getActiveHand();
            Intrinsics.checkNotNullExpressionValue(p.getHands().iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                HandPlayer h;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                int handFirstCardX = cardX;
                for (BlackjackCard bc : h.getBlackjackCards()) {
                    Card card = bc.getCard();
                    Integer n2 = o.getPlayerY();
                    Intrinsics.checkNotNull(n2);
                    this.cptr.paintCard(g, card, cardX, n2 - o.getCardH());
                    cardX += o.getCardSpacer();
                }
                cardX += o.getCardW();
                StringWriter sm = new StringWriter();
                sm.append(h.getMessage());
                Color fg00 = Color.BLACK;
                Color fg01 = Color.WHITE;
                Integer n3 = o.getPlayerChipY();
                Intrinsics.checkNotNull(n3);
                int yloc = n3;
                if (h.getWager().getInitialBet() > 0) {
                    this.chpptr.paintChips(g, handFirstCardX, yloc, h.getWager().getInitialBet());
                    if (h.isDoubleDowned()) {
                        this.chpptr.paintChips(g, handFirstCardX + this.chpptr.getChipWidth() + this.chpptr.getChipHeight(), yloc, h.getWager().getDoubledBet());
                    }
                }
                Integer n4 = o.getPlayerChipY();
                Intrinsics.checkNotNull(n4);
                yloc = n4 - this.chpptr.getChipWidth();
                if (h.getWager().getInitialPayoff() > 0) {
                    this.chpptr.paintChips(g, handFirstCardX, yloc, h.getWager().getInitialPayoff());
                }
                if (h.isDoubleDowned() && h.getWager().getDoubledPayoff() > 0) {
                    this.chpptr.paintChips(g, handFirstCardX + this.chpptr.getChipWidth() + this.chpptr.getChipHeight(), yloc, h.getWager().getDoubledPayoff());
                }
                if (activeHand != null && Intrinsics.areEqual(h, activeHand) && !h.isFinal()) {
                    fg00 = Color.BLACK;
                    fg01 = Color.YELLOW;
                    if (!arrowHasBeenDrawn) {
                        Image image = BlackjackImages.INSTANCE.getArrowImg();
                        double d = handFirstCardX + o.getChipW();
                        Integer n5 = o.getPlayerChipY();
                        Intrinsics.checkNotNull(n5);
                        g.drawImage(image, d, n5.intValue());
                        arrowHasBeenDrawn = true;
                    }
                }
                g.setFont(this.font1);
                g.setFill(fg00);
                String string = sm.toString();
                double d = handFirstCardX;
                Integer n6 = o.getPlayerMsgY();
                Intrinsics.checkNotNull(n6);
                g.fillText(string, d, n6.intValue());
                g.setFill(fg01);
                String string2 = sm.toString();
                double d2 = handFirstCardX + 1;
                Integer n7 = o.getPlayerMsgY();
                Intrinsics.checkNotNull(n7);
                g.fillText(string2, d2, n7 + 1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void paintStatus(BlackjackGameState cs, GraphicsContext g, Tile t) {
        Object[] objectArray;
        if (this.dbg) {
            g.setFill(Color.BLUE);
            g.fillRect(t.getLeft(), t.getTop(), t.getWidth(), t.getHeight());
        }
        g.setFill(Color.WHITE);
        g.setFont(this.font0);
        int y = t.getTop() + this.verticalSeparator;
        Iterator<String> iterator2 = cs.getGameStatusVertical().iterator();
        while (iterator2.hasNext()) {
            void $this$trim$iv;
            Object[] s;
            objectArray = s = iterator2.next();
            GraphicsContext graphicsContext = g;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            graphicsContext.fillText("  " + ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), t.getLeft(), y);
            y += this.verticalSeparator;
        }
        if (this.dbg) {
            String string = "  Action: %s";
            objectArray = new Object[1];
            String string2 = cs.getAction();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            Intrinsics.checkNotNullExpressionValue(string2.toUpperCase(locale), "toUpperCase(...)");
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            g.fillText(string3, t.getLeft(), y);
        }
    }

    public final boolean getDbg() {
        return this.dbg;
    }

    public final void setDbg(boolean bl) {
        this.dbg = bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void paintChips(GraphicsContext g, Tile t, BlackjackGameState cs) {
        if (t == null) {
            return;
        }
        if (this.dbg) {
            g.setFill(Color.CYAN);
            g.fillRect(t.getLeft(), t.getTop(), t.getWidth(), t.getHeight());
        }
        g.setFill(Color.DARKCYAN);
        g.fillRoundRect(t.getLeft(), t.getTop(), t.getWidth(), t.getHeight(), 20.0, 20.0);
        g.setFill(Color.BLACK);
        LayoutChips lc = new LayoutChips(t.getLeft(), t.getBottom(), this.chpptr.getChipWidth(), this.chpptr.getChipHeight());
        this.chpptr.paintChips(g, lc.getChipXnextBet(), lc.getChipY(), cs.getNextBet());
        this.chpptr.paintChips(g, lc.getChipXstack(), lc.getChipY(), cs.getChips() - (long)cs.getNextBet());
        g.setFill(Color.WHITE);
        g.setFont(this.font0);
        int y = t.getTop() + this.verticalSeparator;
        Iterator<String> iterator2 = cs.getGameStatusVertical().iterator();
        while (iterator2.hasNext()) {
            void $this$trim$iv;
            String s;
            String string = s = iterator2.next();
            GraphicsContext graphicsContext = g;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            graphicsContext.fillText("  " + ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), t.getLeft(), y);
            y += this.verticalSeparator;
        }
    }
}

