/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.oldswpkg.games.blackjack;

import com.panopset.blackjackEngine.Card;
import com.panopset.marin.fx.ImageMapCache;
import java.util.Arrays;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\r\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/panopset/marin/oldswpkg/games/blackjack/CardPathKeys;", "", "basePath", "", "ext", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getImage", "Ljavafx/scene/image/Image;", "card", "Lcom/panopset/blackjackEngine/Card;", "find", "id", "getPathFor", "getCardSvgName", "backBlue", "getBackBlue", "()Ljavafx/scene/image/Image;", "backRed", "getBackRed", "desk"})
public final class CardPathKeys {
    @NotNull
    private final String basePath;
    @NotNull
    private final String ext;

    public CardPathKeys(@NotNull String basePath, @NotNull String ext) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(ext, "ext");
        this.basePath = basePath;
        this.ext = ext;
    }

    @Nullable
    public final Image getImage(@NotNull Card card) {
        Intrinsics.checkNotNullParameter(card, "card");
        return this.find(card);
    }

    @Nullable
    public final Image find(@NotNull Card card) {
        Intrinsics.checkNotNullParameter(card, "card");
        Image rtn2 = ImageMapCache.INSTANCE.get(card.name());
        if (rtn2 == null) {
            rtn2 = ImageMapCache.INSTANCE.get(card.name(), this.getPathFor(card));
        }
        return rtn2;
    }

    @Nullable
    public final Image find(@Nullable String id) {
        String string = id;
        Intrinsics.checkNotNull(string);
        Image rtn2 = ImageMapCache.INSTANCE.get(string);
        if (rtn2 == null) {
            rtn2 = ImageMapCache.INSTANCE.get(id, this.getPathFor(id));
        }
        return rtn2;
    }

    @NotNull
    public final String getPathFor(@NotNull Card card) {
        Intrinsics.checkNotNullParameter(card, "card");
        return this.getPathFor(this.getCardSvgName(card));
    }

    @NotNull
    public final String getPathFor(@Nullable String id) {
        String string = "%s%s.%s";
        Object[] objectArray = new Object[]{this.basePath, id, this.ext};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String getCardSvgName(@NotNull Card card) {
        Intrinsics.checkNotNullParameter(card, "card");
        return card.getCardDefinition().getKey();
    }

    @Nullable
    public final Image getBackBlue() {
        return this.find("1B");
    }

    @Nullable
    public final Image getBackRed() {
        return this.find("2B");
    }
}

