/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.secure.checksums;

import com.panopset.compat.ChecksumFunKt;
import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.Nls;
import com.panopset.compat.Padop;
import com.panopset.compat.TextProcessor;
import com.panopset.marin.secure.checksums.ChecksumType;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/panopset/marin/secure/checksums/ChecksumReport;", "", "textProcessor", "Lcom/panopset/compat/TextProcessor;", "<init>", "(Lcom/panopset/compat/TextProcessor;)V", "firstTime", "", "generateReport", "", "file", "Ljava/io/File;", "types", "", "Lcom/panopset/marin/secure/checksums/ChecksumType;", "maxTitleLength", "", "getMaxTitleSize", "generateFileReport", "generateDirectoryReport", "desk"})
public final class ChecksumReport {
    @NotNull
    private final TextProcessor textProcessor;
    private boolean firstTime;
    private int maxTitleLength;

    public ChecksumReport(@NotNull TextProcessor textProcessor) {
        Intrinsics.checkNotNullParameter(textProcessor, "textProcessor");
        this.textProcessor = textProcessor;
        this.firstTime = true;
    }

    public final void generateReport(@NotNull File file, @NotNull List<? extends ChecksumType> types) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(types, "types");
        this.textProcessor.clear();
        if (!file.exists()) {
            CharSequence[] charSequenceArray = new CharSequence[]{Nls.INSTANCE.xlate("File doesn't exist"), Fileop.INSTANCE.getCanonicalPath(file)};
            String string = String.join((CharSequence)":", charSequenceArray);
            Intrinsics.checkNotNullExpressionValue(string, "join(...)");
            Logz.INSTANCE.warn(string);
            return;
        }
        if (file.isDirectory()) {
            this.generateDirectoryReport(file, types);
        } else {
            this.generateFileReport(file, types);
        }
    }

    private final int getMaxTitleSize(List<? extends ChecksumType> types) {
        int i = 0;
        for (ChecksumType checksumType : types) {
            if (checksumType.name().length() <= i) continue;
            i = checksumType.name().length();
        }
        this.maxTitleLength = i;
        return this.maxTitleLength;
    }

    private final void generateFileReport(File file, List<? extends ChecksumType> types) {
        CharSequence[] object = new CharSequence[]{Nls.INSTANCE.xlate("Processing"), Fileop.INSTANCE.getCanonicalPath(file)};
        String string = String.join((CharSequence)": ", object);
        Intrinsics.checkNotNullExpressionValue(string, "join(...)");
        Logz.INSTANCE.green(string);
        if (types.size() > 1) {
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            this.textProcessor.append(string2);
            this.textProcessor.append("\n");
        } else if (types.size() == 1 && this.firstTime) {
            this.textProcessor.append(types.get(0).name());
            this.textProcessor.append("\n");
            this.firstTime = false;
        }
        for (ChecksumType checksumType : types) {
            if (types.size() > 1) {
                this.textProcessor.append(Padop.INSTANCE.leftPad(checksumType.name(), this.getMaxTitleSize(types), ' '));
                this.textProcessor.append(":");
            }
            switch (WhenMappings.$EnumSwitchMapping$0[checksumType.ordinal()]) {
                case 1: {
                    this.textProcessor.append(ChecksumFunKt.byteCount(file));
                    break;
                }
                case 2: {
                    this.textProcessor.append(ChecksumFunKt.md5(file));
                    break;
                }
                case 3: {
                    this.textProcessor.append(ChecksumFunKt.sha1(file));
                    break;
                }
                case 4: {
                    this.textProcessor.append(ChecksumFunKt.sha256(file));
                    break;
                }
                case 5: {
                    this.textProcessor.append(ChecksumFunKt.sha384(file));
                    break;
                }
                case 6: {
                    this.textProcessor.append(ChecksumFunKt.sha512(file));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (types.size() > 1) {
                this.textProcessor.append("\n");
                continue;
            }
            this.textProcessor.append(" " + file.getName() + "\n");
        }
        String string3 = "%s: %s";
        Object[] objectArray = new Object[]{Nls.INSTANCE.xlate("Completed"), Fileop.INSTANCE.getCanonicalPath(file)};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        Logz.INSTANCE.green(string4);
    }

    private final void generateDirectoryReport(File file, List<? extends ChecksumType> types) {
        boolean fount = false;
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File f : fileArray) {
            if (!f.isFile()) continue;
            fount = true;
            Intrinsics.checkNotNull(f);
            this.generateFileReport(f, types);
        }
        if (fount) {
            Logz.INSTANCE.green(Nls.INSTANCE.xlate("Completed."));
        } else {
            String string = "%s:%s";
            Object[] objectArray = new Object[]{Nls.INSTANCE.xlate("No files found in"), Fileop.INSTANCE.getCanonicalPath(file)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            Logz.INSTANCE.warn(string2);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChecksumType.values().length];
            try {
                nArray[ChecksumType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChecksumType.MD5.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChecksumType.SHA1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChecksumType.SHA256.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChecksumType.SHA384.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChecksumType.SHA512.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

