/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableBooleanProperty
extends BooleanPropertyBase
implements StyleableProperty<Boolean> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableBooleanProperty() {
    }

    public StyleableBooleanProperty(boolean bl) {
        super(bl);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Boolean bl) {
        boolean bl2;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        boolean bl3 = bl2 = bl != null && bl != false;
        if (transitionDefinition2 == null) {
            this.set(bl2);
        } else if (this.mediator == null || this.mediator.endValue != bl2) {
            this.mediator = new TransitionMediatorImpl(this.get(), bl2);
            this.mediator.run(transitionDefinition2, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Boolean> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    @Override
    public void set(boolean bl) {
        super.set(bl);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final boolean startValue;
        private final boolean endValue;
        private boolean reversingAdjustedStartValue;

        public TransitionMediatorImpl(boolean bl, boolean bl2) {
            this.startValue = bl;
            this.endValue = bl2;
            this.reversingAdjustedStartValue = bl;
        }

        @Override
        public void onUpdate(double d) {
            StyleableBooleanProperty.super.set(d < 0.5 ? this.startValue : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableBooleanProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableBooleanProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

