/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.UnmodifiableArrayList;
import com.sun.javafx.util.InterpolationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;
import javafx.scene.paint.Color;

public final class Stop
implements Interpolatable<Stop> {
    static final List<Stop> NO_STOPS = List.of(new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.TRANSPARENT));
    private double offset;
    private Color color;
    private int hash = 0;

    static List<Stop> normalize(Stop[] stopArray) {
        List<Stop> list = stopArray == null ? null : Arrays.asList(stopArray);
        return Stop.normalize(list);
    }

    static List<Stop> normalize(List<Stop> list) {
        if (list == null) {
            return NO_STOPS;
        }
        Stop stop = null;
        Stop stop2 = null;
        ArrayList<Stop> arrayList = new ArrayList<Stop>(list.size());
        for (Stop stop3 : list) {
            if (stop3 == null) continue;
            double d = stop3.getOffset();
            if (d <= 0.0) {
                if (stop != null && !(d >= stop.getOffset())) continue;
                stop = stop3;
                continue;
            }
            if (d >= 1.0) {
                if (stop2 != null && !(d < stop2.getOffset())) continue;
                stop2 = stop3;
                continue;
            }
            if (d != d) continue;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Stop stop4 = (Stop)arrayList.get(i);
                if (!(stop4.getOffset() <= d)) continue;
                if (stop4.getOffset() == d) {
                    if (i > 0 && ((Stop)arrayList.get(i - 1)).getOffset() == d) {
                        arrayList.set(i, stop3);
                    } else {
                        arrayList.add(i + 1, stop3);
                    }
                } else {
                    arrayList.add(i + 1, stop3);
                }
                stop3 = null;
                break;
            }
            if (stop3 == null) continue;
            arrayList.add(0, stop3);
        }
        if (stop == null) {
            Object object;
            if (arrayList.isEmpty()) {
                if (stop2 == null) {
                    return NO_STOPS;
                }
                object = stop2.getColor();
            } else {
                object = ((Stop)arrayList.get(0)).getColor();
                if (stop2 == null && arrayList.size() == 1) {
                    arrayList.clear();
                }
            }
            stop = new Stop(0.0, (Color)object);
        } else if (stop.getOffset() < 0.0) {
            stop = new Stop(0.0, stop.getColor());
        }
        arrayList.add(0, stop);
        if (stop2 == null) {
            stop2 = new Stop(1.0, ((Stop)arrayList.get(arrayList.size() - 1)).getColor());
        } else if (stop2.getOffset() > 1.0) {
            stop2 = new Stop(1.0, stop2.getColor());
        }
        arrayList.add(stop2);
        return Collections.unmodifiableList(arrayList);
    }

    static List<Stop> interpolateLists(List<Stop> list, List<Stop> list2, double d) {
        Objects.requireNonNull(list, "firstList cannot be null");
        Objects.requireNonNull(list2, "secondList cannot be null");
        if (!list.isEmpty() && list.get(0).getOffset() > 0.0) {
            throw new IllegalArgumentException("firstList is not normalized");
        }
        if (!list2.isEmpty() && list2.get(0).getOffset() > 0.0) {
            throw new IllegalArgumentException("secondList is not normalized");
        }
        if (d <= 0.0) {
            return list;
        }
        if (d >= 1.0) {
            return list2;
        }
        Stop[] stopArray = new Stop[list.size() + list2.size()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = list.size();
        int n5 = list2.size();
        while (n2 < n4 && n3 < n5) {
            Stop stop = list.get(n2);
            Stop stop2 = list2.get(n3);
            if (stop.offset == stop2.offset) {
                stopArray[n] = stop.color.equals(stop2.color) ? stop : new Stop(stop.offset, stop.color.interpolate(stop2.color, d));
                ++n2;
                ++n3;
            } else if (stop.offset < stop2.offset) {
                stopArray[n] = Stop.interpolateVirtualStop(stop, stop2, list2.get(n3 - 1), 1.0 - d);
                ++n2;
            } else {
                stopArray[n] = Stop.interpolateVirtualStop(stop2, stop, list.get(n2 - 1), d);
                ++n3;
            }
            ++n;
        }
        return new UnmodifiableArrayList<Stop>(stopArray, n);
    }

    private static Stop interpolateVirtualStop(Stop stop, Stop stop2, Stop stop3, double d) {
        double d2 = (stop.offset - stop3.offset) / (stop2.offset - stop3.offset);
        Color color = stop3.color.interpolate(stop2.color, d2);
        Color color2 = color.interpolate(stop.color, d);
        return color2.equals(stop.color) ? stop : new Stop(stop.offset, color2);
    }

    public final double getOffset() {
        return this.offset;
    }

    public final Color getColor() {
        return this.color;
    }

    public Stop(@NamedArg(value="offset") double d, @NamedArg(value="color", defaultValue="BLACK") Color color) {
        this.offset = d;
        this.color = Objects.requireNonNullElse(color, Color.TRANSPARENT);
    }

    @Override
    public Stop interpolate(Stop stop, double d) {
        Objects.requireNonNull(stop, "endValue cannot be null");
        if (d <= 0.0) {
            return this;
        }
        if (d >= 1.0) {
            return stop;
        }
        Color color = this.color.interpolate(stop.color, d);
        double d2 = InterpolationUtils.interpolate(this.offset, stop.offset, d);
        if (d2 == this.offset && color == this.color) {
            return this;
        }
        if (d2 == stop.offset && color == stop.color) {
            return stop;
        }
        return new Stop(d2, color);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Stop) {
            Stop stop = (Stop)object;
            return this.offset == stop.offset && this.color.equals(stop.color);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l = 17L;
            l = 37L * l + Double.doubleToLongBits(this.offset);
            l = 37L * l + (long)this.color.hashCode();
            this.hash = (int)(l ^ l >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return String.valueOf(this.color) + " " + this.offset * 100.0 + "%";
    }
}

