/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.CasinoRules;
import com.panopset.blackjackEngine.Situation;
import com.panopset.blackjackEngine.StratCat;
import com.panopset.blackjackEngine.StrategyAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/panopset/blackjackEngine/StrategyLine;", "", "stratCat", "Lcom/panopset/blackjackEngine/StratCat;", "source", "", "config", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "<init>", "(Lcom/panopset/blackjackEngine/StratCat;Ljava/lang/String;Lcom/panopset/blackjackEngine/BlackjackConfiguration;)V", "getStratCat", "()Lcom/panopset/blackjackEngine/StratCat;", "getSource", "()Ljava/lang/String;", "strategyLineElements", "", "key", "getKey", "getAction", "situation", "Lcom/panopset/blackjackEngine/Situation;", "getTextForDealerUpCard", "card", "Lcom/panopset/blackjackEngine/BlackjackCard;", "getStrategyLineElements", "", "toString", "blackjackEngine"})
public final class StrategyLine {
    @NotNull
    private final StratCat stratCat;
    @NotNull
    private final String source;
    @NotNull
    private final BlackjackConfiguration config;
    @NotNull
    private List<String> strategyLineElements;
    @NotNull
    private final String key;

    public StrategyLine(@NotNull StratCat stratCat, @NotNull String source, @NotNull BlackjackConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)stratCat, "stratCat");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(config, "config");
        this.stratCat = stratCat;
        this.source = source;
        this.config = config;
        this.strategyLineElements = new ArrayList();
        StringTokenizer st = new StringTokenizer(this.source, " ");
        while (st.hasMoreElements()) {
            String string = st.nextToken();
            Intrinsics.checkNotNullExpressionValue(string, "nextToken(...)");
            this.strategyLineElements.add(string);
        }
        this.key = this.getStrategyLineElements().get(0);
    }

    @NotNull
    public final StratCat getStratCat() {
        return this.stratCat;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final String getAction(@NotNull Situation situation) {
        Intrinsics.checkNotNullParameter(situation, "situation");
        if (situation.getDealerUpCard() == null) {
            return "l";
        }
        return new StrategyAction(situation, new CasinoRules(this.config.isLateSurrenderAllowed(), this.config.isDealerHitSoft17(), this.config.isDoubleAfterSplitAllowed(), this.config.getDecks())).getRecommendedAction(this.getTextForDealerUpCard(situation.getDealerUpCard()));
    }

    private final String getTextForDealerUpCard(BlackjackCard card) {
        return this.getStrategyLineElements().get(card.getSoftValue() - 1);
    }

    private final List<String> getStrategyLineElements() {
        return this.strategyLineElements;
    }

    @NotNull
    public String toString() {
        return this.source;
    }
}

