/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000fJ \u0010\u0018\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u001fR$\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0018\u0010\u0012\u001a\n \u0006*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/panopset/compat/Dateop;", "", "<init>", "()V", "ZONE_ID", "Ljava/time/ZoneId;", "kotlin.jvm.PlatformType", "getZONE_ID", "()Ljava/time/ZoneId;", "setZONE_ID", "(Ljava/time/ZoneId;)V", "Ljava/time/ZoneId;", "show", "", "date", "Ljava/time/LocalDate;", "parse", "source", "YMD_FMT", "Ljava/time/format/DateTimeFormatter;", "Ljava/time/format/DateTimeFormatter;", "fill2", "value", "", "createDateKey", "ld", "createMonthKey", "yr", "mn", "dy", "toPacific", "Ljava/util/Date;", "oldest", "toLocalDate", "compat"})
@SourceDebugExtension(value={"SMAP\nDateop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dateop.kt\ncom/panopset/compat/Dateop\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,50:1\n108#2:51\n80#2,22:52\n*S KotlinDebug\n*F\n+ 1 Dateop.kt\ncom/panopset/compat/Dateop\n*L\n16#1:51\n16#1:52,22\n*E\n"})
public final class Dateop {
    @NotNull
    public static final Dateop INSTANCE = new Dateop();
    private static ZoneId ZONE_ID = ZoneId.of("America/Los_Angeles");
    private static final DateTimeFormatter YMD_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private Dateop() {
    }

    public final ZoneId getZONE_ID() {
        return ZONE_ID;
    }

    public final void setZONE_ID(ZoneId zoneId) {
        ZONE_ID = zoneId;
    }

    @NotNull
    public final String show(@Nullable LocalDate date) {
        String string = YMD_FMT.format(date);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @NotNull
    public final LocalDate parse(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        String $this$trim$iv = source;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        LocalDate localDate = LocalDate.parse(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), YMD_FMT);
        Intrinsics.checkNotNullExpressionValue(localDate, "parse(...)");
        return localDate;
    }

    private final String fill2(int value) {
        return value < 10 ? "0" + value : "" + value;
    }

    @NotNull
    public final String createDateKey(@NotNull LocalDate ld) {
        Intrinsics.checkNotNullParameter(ld, "ld");
        return this.createDateKey(ld.getYear(), ld.getMonthValue(), ld.getDayOfMonth());
    }

    @NotNull
    public final String createMonthKey(@NotNull LocalDate ld) {
        Intrinsics.checkNotNullParameter(ld, "ld");
        return this.createMonthKey(ld.getYear(), ld.getMonthValue());
    }

    private final String createDateKey(int yr, int mn, int dy) {
        String string = "%s-%s";
        Object[] objectArray = new Object[]{this.createMonthKey(yr, mn), this.fill2(dy)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private final String createMonthKey(int yr, int mn) {
        String string = "%d-%s";
        Object[] objectArray = new Object[]{yr, this.fill2(mn)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final Date toPacific(@NotNull LocalDate oldest) {
        Intrinsics.checkNotNullParameter(oldest, "oldest");
        Date date = Date.from(oldest.atStartOfDay(ZONE_ID).toInstant());
        Intrinsics.checkNotNullExpressionValue(date, "from(...)");
        return date;
    }

    @NotNull
    public final LocalDate toLocalDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter(date, "date");
        LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(ZONE_ID).toLocalDate();
        Intrinsics.checkNotNullExpressionValue(localDate, "toLocalDate(...)");
        return localDate;
    }
}

