/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.HttpComm;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0007J\u001a\u0010\t\u001a\u00020\u00002\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/panopset/compat/HttpCommFactory;", "", "urlStr", "", "<init>", "(Ljava/lang/String;)V", "httpComm", "Lcom/panopset/compat/HttpComm;", "assembleHttpComm", "withHeaders", "headers", "", "withPostData", "postData", "addHeader", "", "key", "value", "compat"})
public final class HttpCommFactory {
    @NotNull
    private final HttpComm httpComm;

    public HttpCommFactory(@NotNull String urlStr) {
        Intrinsics.checkNotNullParameter(urlStr, "urlStr");
        this.httpComm = new HttpComm(urlStr);
    }

    @NotNull
    public final HttpComm assembleHttpComm() {
        this.httpComm.preassemble();
        return this.httpComm;
    }

    @NotNull
    public final HttpCommFactory withHeaders(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Iterator<Map.Entry<String, String>> iterator2 = headers.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> e;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            String string = e.getKey();
            Intrinsics.checkNotNullExpressionValue(string, "<get-key>(...)");
            String string2 = e.getValue();
            Intrinsics.checkNotNullExpressionValue(string2, "<get-value>(...)");
            this.addHeader(string, string2);
        }
        return this;
    }

    @NotNull
    public final HttpCommFactory withPostData(@NotNull String postData) {
        Intrinsics.checkNotNullParameter(postData, "postData");
        this.httpComm.setPostData(postData);
        return this;
    }

    private final void addHeader(String key, String value) {
        this.httpComm.addHeader(key, value);
    }
}

