/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.AlertColor;
import com.panopset.compat.Fileop;
import com.panopset.compat.LogEntry;
import com.panopset.compat.LogEntryKt;
import com.panopset.compat.LogpanKt;
import com.panopset.compat.Stringop;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\t\u001a\u00020\u00052\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0011J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u000e\u0010\u0014\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0002J\u001a\u0010\u000b\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0011J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0011J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u001dH\u0002J\u000e\u0010'\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0011R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006("}, d2={"Lcom/panopset/compat/Logpan;", "", "<init>", "()V", "dspmsglg", "", "msg", "", "infolg", "warnlg", "debuglg", "errorMsglg", "auditlg", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorExlg", "", "greenlg", "handlelg", "e", "message", "file", "Ljava/io/File;", "getStackTracelg", "throwable", "handleExceptionlg", "reportlg", "logRecord", "Lcom/panopset/compat/LogEntry;", "getEntryStackAsTextlg", "clearlg", "stacklg", "Ljava/util/Deque;", "getStacklg", "()Ljava/util/Deque;", "printHistorylg", "logaloglg", "logEntry", "getStackTraceAndCauseslg", "compat"})
public final class Logpan {
    @NotNull
    public static final Logpan INSTANCE = new Logpan();
    @NotNull
    private static final Deque<LogEntry> stacklg = new ConcurrentLinkedDeque();

    private Logpan() {
    }

    public final void dspmsglg(@Nullable String msg) {
        this.infolg(msg);
    }

    public final void infolg(@Nullable String msg) {
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue(level, "INFO");
        String string = this.auditlg(msg);
        Intrinsics.checkNotNull(string);
        this.reportlg(new LogEntry(AlertColor.GRN, level, string));
    }

    public final void warnlg(@Nullable String msg) {
        Level level = Level.WARNING;
        Intrinsics.checkNotNullExpressionValue(level, "WARNING");
        String string = this.auditlg(msg);
        Intrinsics.checkNotNull(string);
        this.reportlg(new LogEntry(AlertColor.YLW, level, string));
    }

    public final void debuglg(@Nullable String msg) {
        Level level = Level.FINE;
        Intrinsics.checkNotNullExpressionValue(level, "FINE");
        String string = this.auditlg(msg);
        Intrinsics.checkNotNull(string);
        this.reportlg(new LogEntry(AlertColor.ORG, level, string));
    }

    public final void errorMsglg(@Nullable String msg) {
        Level level = Level.SEVERE;
        Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
        String string = this.auditlg(msg);
        Intrinsics.checkNotNull(string);
        this.reportlg(new LogEntry(AlertColor.RED, level, string));
    }

    private final String auditlg(String msg) {
        return msg;
    }

    public final void warnlg(@NotNull Exception ex) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        this.warnlg(ex.getMessage());
    }

    public final void errorExlg(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        this.handleExceptionlg(ex);
    }

    public final void errorMsglg(@NotNull String msg, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(ex, "ex");
        this.errorMsglg(msg);
        this.handleExceptionlg(ex);
    }

    private final void greenlg(String msg) {
        this.dspmsglg(msg);
    }

    private final void handlelg(Exception e) {
        Exception exception = e;
        Intrinsics.checkNotNull(exception);
        this.handleExceptionlg(exception);
    }

    public final void errorMsglg(@Nullable String message, @Nullable File file) {
        if (file == null) {
            this.errorMsglg("Null file.");
            return;
        }
        this.errorMsglg(message + ": " + Fileop.INSTANCE.getCanonicalPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getStackTracelg(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        Closeable closeable = new StringWriter();
        Throwable throwable2 = null;
        try {
            String string;
            StringWriter sw = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter(sw);
            Throwable throwable3 = null;
            try {
                PrintWriter pw = (PrintWriter)closeable2;
                boolean bl2 = false;
                throwable.printStackTrace(pw);
                pw.flush();
                String string2 = sw.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                string = string2;
            }
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        CloseableKt.closeFinally(closeable2, throwable3);
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
            }
            CloseableKt.closeFinally(closeable2, throwable3);
            String string3 = string;
            return string3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable2);
        }
    }

    public final void errorMsglg(@NotNull File file, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(ex, "ex");
        this.infolg(Fileop.INSTANCE.getCanonicalPath(file));
        this.errorExlg(ex);
    }

    private final void handleExceptionlg(Throwable ex) {
        LogpanKt.access$getLogger$p().log(Level.SEVERE, ex.getMessage(), ex);
        Level level = Level.SEVERE;
        Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
        String string = ex.getMessage();
        if (string == null) {
            string = "Unexpected error, if your pull request is accepted, we'll send you 1000 currently worthless Panopset shares.";
        }
        LogEntry logEntry = new LogEntry(AlertColor.RED, level, string);
        this.logaloglg(logEntry);
    }

    private final void reportlg(LogEntry logRecord) {
        LogpanKt.access$getLogger$p().log(logRecord.getLevel(), logRecord.getMessage());
        this.logaloglg(logRecord);
    }

    @NotNull
    public final String getEntryStackAsTextlg() {
        return this.printHistorylg();
    }

    public final void clearlg() {
        stacklg.clear();
    }

    @NotNull
    public final Deque<LogEntry> getStacklg() {
        return stacklg;
    }

    private final String printHistorylg() {
        StringWriter sw = new StringWriter();
        Iterator<LogEntry> iterator2 = stacklg.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LogEntry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            LogEntry lr = iterator3.next();
            sw.append(LogEntryKt.getTimestampFormat().format(lr.getTimestamp()));
            sw.append(lr.getMessage());
            sw.append("\n");
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final void logaloglg(LogEntry logEntry) {
        if (stacklg.size() > 10) {
            stacklg.removeLast();
        }
        stacklg.push(logEntry);
    }

    @NotNull
    public final String getStackTraceAndCauseslg(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        StringWriter sw = new StringWriter();
        sw.append("See log");
        sw.append(": ");
        sw.append(throwable.getMessage());
        sw.append(Stringop.INSTANCE.getEol());
        sw.append("*************************");
        sw.append(Stringop.INSTANCE.getEol());
        sw.append(this.getStackTracelg(throwable));
        sw.append(Stringop.INSTANCE.getEol());
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            sw.append("*************************");
            sw.append(Stringop.INSTANCE.getEol());
            sw.append(this.getStackTracelg(cause));
            sw.append(Stringop.INSTANCE.getEol());
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

