/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.PersistentMap;
import com.panopset.compat.Propop;
import com.panopset.compat.Stringop;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\rJ\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u001d\u001a\u00020\u0007R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0005R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/panopset/compat/PersistentMapFile;", "Lcom/panopset/compat/PersistentMap;", "newFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "setNewFile", "", "put", "key", "", "value", "entrySet", "", "", "", "getMapValue", "dft", "containsKey", "", "purge", "flush", "getProps", "Ljava/util/Properties;", "file", "getFile", "()Ljava/io/File;", "setFile", "props", "load", "compat"})
public final class PersistentMapFile
implements PersistentMap {
    @NotNull
    private File file;
    @NotNull
    private Properties props;

    public PersistentMapFile(@NotNull File newFile) {
        Intrinsics.checkNotNullParameter(newFile, "newFile");
        this.file = new File("");
        this.props = new Properties();
        this.setNewFile(newFile);
    }

    public final void setNewFile(@NotNull File newFile) {
        Intrinsics.checkNotNullParameter(newFile, "newFile");
        this.file = newFile;
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            this.getProps().setProperty(key, value);
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    @NotNull
    public final Set<Map.Entry<Object, Object>> entrySet() {
        Set<Map.Entry<Object, Object>> set = this.getProps().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        return set;
    }

    @Override
    @NotNull
    public String getMapValue(@NotNull String key, @NotNull String dft) {
        String string;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(dft, "dft");
        if (Stringop.INSTANCE.isPopulated(key)) {
            string = this.getProps().getProperty(key);
            if (string == null) {
                return dft;
            }
        } else {
            string = dft;
        }
        return string;
    }

    @Override
    @NotNull
    public String getMapValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.getMapValue(key, "");
    }

    @Override
    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.getProps().containsKey(key);
    }

    public final void purge() {
        if (Fileop.INSTANCE.fileExists(this.file)) {
            this.file.delete();
        }
    }

    public final void flush() {
        try {
            Propop.INSTANCE.save(this.getProps(), this.file);
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    private final Properties getProps() {
        if (this.props.isEmpty()) {
            this.load();
        }
        return this.props;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.file = file;
    }

    public final void load() {
        this.props.clear();
        this.props = Propop.INSTANCE.load(this.file);
    }
}

