/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.panopset.compat.AppVersion;
import com.panopset.compat.ChecksumFunKt;
import com.panopset.compat.Fileop;
import com.panopset.compat.Jsonop;
import com.panopset.compat.Stringop;
import com.panopset.marin.bootstrap.Platform;
import com.panopset.marin.bootstrap.PlatformMap;
import com.panopset.marin.secure.checksums.ChecksumType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007\"\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"generateJsonForJar", "", "props", "Ljava/util/Properties;", "generateJsonForInstaller", "generateJsonObsolete", "file", "Ljava/io/File;", "createJsonMap", "", "", "platformKey", "installerFile", "fsp", "getFsp", "()Ljava/lang/String;", "ush", "getUsh", "desk"})
public final class GenerateAppInfoKt {
    @NotNull
    private static final String fsp = Stringop.INSTANCE.getFSP();
    @NotNull
    private static final String ush = Stringop.INSTANCE.getUSH();

    private static final void generateJsonForJar(Properties props) {
        String platformKey = props.getProperty("PLATFORM_KEY");
        String panopsetJarPath = "./legacy/target";
        File jsonFile = new File(panopsetJarPath + fsp + props.getProperty("PLATFORM_KEY") + "OneJar.json");
        Fileop.INSTANCE.checkParent(jsonFile);
        String checksumPath = ush + fsp + "panopset.jar";
        Jsonop<Map<String, String>> jsonop = new Jsonop<Map<String, String>>();
        Intrinsics.checkNotNull(platformKey);
        String json = jsonop.toJson(GenerateAppInfoKt.createJsonMap(platformKey, new File(checksumPath)));
        Fileop.INSTANCE.write(json, jsonFile);
    }

    private static final void generateJsonForInstaller(Properties props) {
        String platformKey = props.getProperty("PLATFORM_KEY");
        String platformInstallerPath = "./target";
        File platformInstallerDir = new File(platformInstallerPath);
        boolean firstTime = true;
        if (platformInstallerDir.exists() && platformInstallerDir.isDirectory()) {
            if (platformInstallerDir.listFiles() == null) {
                throw new Exception(platformInstallerDir.getCanonicalPath() + " is empty!");
            }
            File[] fileArray = platformInstallerDir.listFiles();
            Intrinsics.checkNotNull(fileArray);
            for (File file : fileArray) {
                if (!firstTime || !file.exists() || file.isDirectory()) continue;
                Jsonop<Map<String, String>> jsonop = new Jsonop<Map<String, String>>();
                Intrinsics.checkNotNull(platformKey);
                Intrinsics.checkNotNull(file);
                String json = jsonop.toJson(GenerateAppInfoKt.createJsonMap(platformKey, file));
                Fileop.INSTANCE.write(json, new File(platformInstallerPath + fsp + file.getName() + ".json"));
                firstTime = false;
            }
        }
    }

    private static final void generateJsonObsolete(File file) {
        String name = file.getName();
        for (Platform platform : new PlatformMap().getMap().values()) {
            String json;
            if (!Intrinsics.areEqual(FilesKt.getExtension(file), FilesKt.getExtension(new File(platform.getArtifactName())))) continue;
            File targetFile = new File("/var/www/html/downloads/pci_" + name + ".json");
            File targetFileForOneJar = new File("/var/www/html/downloads/" + platform.getFxArch() + "OneJar.json");
            Fileop.INSTANCE.checkParent(targetFileForOneJar);
            if (!targetFile.exists()) {
                json = new Jsonop<Map<String, String>>().toJson(GenerateAppInfoKt.createJsonMap(platform.getFxArch(), file));
                Fileop.INSTANCE.write(json, targetFile);
            }
            if (targetFileForOneJar.exists()) continue;
            json = new Jsonop<Map<String, String>>().toJson(GenerateAppInfoKt.createJsonMap(platform.getFxArch(), new File("/var/www/html/downloads/" + platform.getFxArch() + "/panopset.jar")));
            Fileop.INSTANCE.write(json, targetFileForOneJar);
        }
    }

    @NotNull
    public static final Map<String, String> createJsonMap(@NotNull String platformKey, @NotNull File installerFile) {
        Intrinsics.checkNotNullParameter(platformKey, "platformKey");
        Intrinsics.checkNotNullParameter(installerFile, "installerFile");
        HashMap map = new HashMap();
        ((Map)map).put("platformKey", platformKey);
        ((Map)map).put("version", AppVersion.INSTANCE.getFullVersion());
        ((Map)map).put("bytes", ChecksumFunKt.byteCount(installerFile));
        ((Map)map).put(ChecksumType.SHA512.key, ChecksumFunKt.sha512(installerFile));
        ((Map)map).put("ifn", installerFile.getName());
        return map;
    }

    @NotNull
    public static final String getFsp() {
        return fsp;
    }

    @NotNull
    public static final String getUsh() {
        return ush;
    }

    public static final /* synthetic */ void access$generateJsonForJar(Properties props) {
        GenerateAppInfoKt.generateJsonForJar(props);
    }

    public static final /* synthetic */ void access$generateJsonForInstaller(Properties props) {
        GenerateAppInfoKt.generateJsonForInstaller(props);
    }
}

