/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.lowerclass;

import com.panopset.compat.ClassVersion;
import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.MajorVersion;
import com.panopset.compat.Stringop;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00062\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007H\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/panopset/desk/utilities/lowerclass/VersionMakeup;", "", "<init>", "()V", "map", "", "", "", "Lcom/panopset/compat/MajorVersion;", "", "clear", "", "analyze", "file", "Ljava/io/File;", "printDetails", "", "report", "getReport", "()Ljava/lang/String;", "genRpt", "fileName", "genDirectoryReport", "genClassReport", "genJarReport", "updateReportMap", "name", "jvs", "updateStatsForJar", "dirFile", "classReport", "Ljava/io/StringWriter;", "updateStatsForClass", "readClassVersion", "Lcom/panopset/compat/ClassVersion;", "dis", "Ljava/io/DataInputStream;", "createVersionMap", "desk"})
public final class VersionMakeup {
    @NotNull
    private final Map<String, Map<MajorVersion, Integer>> map;
    @NotNull
    private StringWriter classReport;

    public VersionMakeup() {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        this.map = sortedMap;
        this.classReport = new StringWriter();
    }

    private final void clear() {
        this.map.clear();
        this.classReport = new StringWriter();
    }

    public final void analyze(@NotNull File file, boolean printDetails) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.clear();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        this.genRpt(string, file, printDetails);
    }

    @NotNull
    public final String getReport() {
        StringWriter tp = new StringWriter();
        for (Map.Entry<String, Map<MajorVersion, Integer>> entry : this.map.entrySet()) {
            String key = entry.getKey();
            Map<MajorVersion, Integer> jvs = entry.getValue();
            tp.append(key);
            tp.append(" > ");
            boolean firstTime = true;
            for (Map.Entry<MajorVersion, Integer> entry2 : jvs.entrySet()) {
                MajorVersion key1 = entry2.getKey();
                int value = ((Number)entry2.getValue()).intValue();
                if (firstTime) {
                    firstTime = false;
                } else {
                    tp.append(",");
                }
                tp.append(key1.getStrRep());
                tp.append(" " + value);
            }
            tp.append("\n");
        }
        if (Stringop.INSTANCE.isPopulated(this.classReport.toString())) {
            tp.append("\n");
            tp.append("\n");
            tp.append(this.classReport.toString());
        }
        String string = tp.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final void genRpt(String fileName, File file, boolean printDetails) {
        if (file == null) {
            Logz.INSTANCE.warn("No file selected.");
            return;
        }
        if (!file.exists()) {
            Logz.INSTANCE.errorMsg("File doesn't exist.", file);
            return;
        }
        if (file.isDirectory()) {
            this.genDirectoryReport(fileName, file, printDetails);
        } else {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String ext = Fileop.INSTANCE.getExtension(string);
            if (Intrinsics.areEqual("class", ext)) {
                this.genClassReport(fileName, file, printDetails);
            } else if (Intrinsics.areEqual("jar", ext)) {
                this.genJarReport(file, printDetails);
            } else {
                Logz.INSTANCE.warn("Selected file is not a jar or class.");
                return;
            }
        }
        String string = "genReport complete for: %s";
        Object[] objectArray = new Object[]{Fileop.INSTANCE.getCanonicalPath(file)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Logz.INSTANCE.green(string2);
    }

    private final void genDirectoryReport(String fileName, File file, boolean printDetails) {
        File[] list = file.listFiles();
        if (list != null) {
            Iterator<File> iterator2 = ArrayIteratorKt.iterator(list);
            while (iterator2.hasNext()) {
                File f = iterator2.next();
                if (f.isDirectory()) {
                    Intrinsics.checkNotNull(f);
                    this.genDirectoryReport(fileName, f, printDetails);
                    continue;
                }
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                String ext = Fileop.INSTANCE.getExtension(string);
                if (Intrinsics.areEqual("class", ext)) {
                    Intrinsics.checkNotNull(f);
                    this.genClassReport(fileName, f, printDetails);
                    continue;
                }
                if (!Intrinsics.areEqual("jar", ext)) continue;
                Intrinsics.checkNotNull(f);
                this.genJarReport(f, printDetails);
            }
        }
    }

    private final void genClassReport(String fileName, File file, boolean printDetails) {
        this.updateReportMap(fileName, this.updateStatsForClass(fileName, file, printDetails));
    }

    private final void genJarReport(File file, boolean printDetails) {
        String string = "Processing jar: %s";
        Object[] objectArray = new Object[]{file.getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Logz.INSTANCE.green(string2);
        String string3 = file.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        this.updateReportMap(string3, this.updateStatsForJar(file, printDetails));
    }

    private final void updateReportMap(String name, Map<MajorVersion, Integer> jvs) {
        Map<MajorVersion, Integer> map = jvs;
        if (!(map == null || map.isEmpty())) {
            this.map.put(name, jvs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<MajorVersion, Integer> updateStatsForJar(File dirFile, boolean printDetails) {
        Map<MajorVersion, Integer> jvs = this.createVersionMap();
        try {
            Closeable closeable = new JarFile(dirFile);
            Throwable throwable = null;
            try {
                JarFile jar = (JarFile)closeable;
                boolean bl = false;
                Enumeration<JarEntry> enumEntries = jar.entries();
                while (enumEntries.hasMoreElements()) {
                    JarEntry entry = enumEntries.nextElement();
                    InputStream inputStream = jar.getInputStream(entry);
                    try {
                        Closeable closeable2 = new DataInputStream(inputStream);
                        Throwable throwable2 = null;
                        try {
                            DataInputStream dis = (DataInputStream)closeable2;
                            boolean bl2 = false;
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            ClassVersion cv = this.readClassVersion(string, dis, printDetails);
                            Integer count = jvs.get((Object)cv.getMajorVersion());
                            if (count == null) {
                                jvs.put(cv.getMajorVersion(), 1);
                            } else {
                                jvs.put(cv.getMajorVersion(), count + 1);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, throwable2);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorMsg(Fileop.INSTANCE.getCanonicalPath(dirFile));
        }
        return jvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<MajorVersion, Integer> updateStatsForClass(String name, File dirFile, boolean printDetails) {
        Object object = "Processing class: %s";
        Object object2 = new Object[]{name};
        String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        Logz.INSTANCE.green(string);
        Map<MajorVersion, Integer> jvs = this.createVersionMap();
        try {
            object = new FileInputStream(dirFile);
            object2 = null;
            try {
                FileInputStream fis = (FileInputStream)object;
                boolean bl = false;
                Closeable closeable = new DataInputStream(fis);
                Throwable throwable = null;
                try {
                    DataInputStream dis = (DataInputStream)closeable;
                    boolean bl2 = false;
                    ClassVersion cv = this.readClassVersion(name, dis, printDetails);
                    jvs.put(cv.getMajorVersion(), 1);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
        return jvs;
    }

    private final ClassVersion readClassVersion(String name, DataInputStream dis, boolean printDetails) throws IOException {
        if (dis.available() > 0 && Intrinsics.areEqual("class", Fileop.INSTANCE.getExtension(name))) {
            int magic = dis.readInt();
            if (magic != -889275714) {
                Logz.INSTANCE.errorMsg(name + " is not a java class! this should be 0xcafebabe:" + Integer.toHexString(magic));
            } else {
                int minor = dis.readUnsignedShort();
                int major = dis.readUnsignedShort();
                MajorVersion majorVersion = MajorVersion.Companion.findFromHexString(Integer.toHexString(major));
                String string = Integer.toHexString(minor);
                Intrinsics.checkNotNullExpressionValue(string, "toHexString(...)");
                ClassVersion classVersion = new ClassVersion(majorVersion, string);
                if (printDetails) {
                    this.classReport.append(name);
                    this.classReport.append(" major: ");
                    this.classReport.append(classVersion.getMajorVersion().getStrRep());
                    this.classReport.append(" minor: ");
                    this.classReport.append(classVersion.getMinorVersion());
                    this.classReport.append("\n");
                }
                return classVersion;
            }
        }
        return new ClassVersion(MajorVersion.UNDEFINED, "");
    }

    private final Map<MajorVersion, Integer> createVersionMap() {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        return sortedMap;
    }
}

