/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.skyscraper;

import com.panopset.desk.utilities.skyscraper.FloorKt;
import com.panopset.flywheel.FlywheelBuilder;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanCheckboxMenu;
import com.panopset.fxapp.PanChoiceBox;
import com.panopset.fxapp.PanComponentFactory;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\"J\u0018\u0010)\u001a\u00020(2\u0006\u0010&\u001a\u00020\"2\u0006\u0010*\u001a\u00020\"H\u0002J\u000e\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\"J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\"H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u001e\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R)\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0#0!\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/panopset/desk/utilities/skyscraper/Floor;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "panCheckboxMenu", "Lcom/panopset/fxapp/PanCheckboxMenu;", "getPanCheckboxMenu", "()Lcom/panopset/fxapp/PanCheckboxMenu;", "setPanCheckboxMenu", "(Lcom/panopset/fxapp/PanCheckboxMenu;)V", "urlTextField", "Ljavafx/scene/control/TextField;", "getUrlTextField", "()Ljavafx/scene/control/TextField;", "urlOutField", "getUrlOutField", "responseTextArea", "Ljavafx/scene/control/TextArea;", "getResponseTextArea", "()Ljavafx/scene/control/TextArea;", "postMethodChoiceBox", "Lcom/panopset/fxapp/PanChoiceBox;", "getPostMethodChoiceBox", "()Lcom/panopset/fxapp/PanChoiceBox;", "headerTextArea", "getHeaderTextArea", "bodyTextArea", "getBodyTextArea", "envMap", "Ljava/util/SortedMap;", "", "", "getEnvMap", "()Ljava/util/SortedMap;", "envMapKey", "updateUrlOutTFfromUrlTextField", "", "updateUrlOutTFfromFreshValue", "newValue", "updateResponse", "msg", "updateUrlOutTFdirect", "value", "desk"})
public final class Floor {
    @NotNull
    private final FxDoc fxDoc;
    public PanCheckboxMenu panCheckboxMenu;
    @NotNull
    private final TextField urlTextField;
    @NotNull
    private final TextField urlOutField;
    @NotNull
    private final TextArea responseTextArea;
    @NotNull
    private final PanChoiceBox postMethodChoiceBox;
    @NotNull
    private final TextArea headerTextArea;
    @NotNull
    private final TextArea bodyTextArea;
    @NotNull
    private final SortedMap<String, Map<String, String>> envMap;
    @NotNull
    private String envMapKey;

    public Floor(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
        this.urlTextField = PanComponentFactory.INSTANCE.createPanInputTextFieldHGrow(this.fxDoc, "url", "Please enter a URL", "URL of the API you wish to test.");
        this.urlOutField = PanComponentFactory.INSTANCE.createPanOutputTextFieldHGrow(this.fxDoc, "url", "URL after ENV (environment) variable substitution.");
        this.responseTextArea = PanComponentFactory.INSTANCE.createPanTextArea(this.fxDoc);
        this.postMethodChoiceBox = PanComponentFactory.INSTANCE.createPanChoiceBox(this.fxDoc, "postMethod", FloorKt.access$getHttpMethods$p(), "");
        this.headerTextArea = PanComponentFactory.INSTANCE.createPersistentPanTextArea(this.fxDoc, "headers", "Please enter headers.", "Header format is key:value");
        this.bodyTextArea = PanComponentFactory.INSTANCE.createPersistentPanTextArea(this.fxDoc, "body", "Please enter a BODY for POSTs", "BODY you wish to POST to the API.");
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        this.envMap = sortedMap;
        this.envMapKey = "";
        this.urlTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> Floor._init_$lambda$1((arg_0, arg_1, arg_2) -> Floor._init_$lambda$0(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final PanCheckboxMenu getPanCheckboxMenu() {
        PanCheckboxMenu panCheckboxMenu2 = this.panCheckboxMenu;
        if (panCheckboxMenu2 != null) {
            return panCheckboxMenu2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("panCheckboxMenu");
        return null;
    }

    public final void setPanCheckboxMenu(@NotNull PanCheckboxMenu panCheckboxMenu2) {
        Intrinsics.checkNotNullParameter(panCheckboxMenu2, "<set-?>");
        this.panCheckboxMenu = panCheckboxMenu2;
    }

    @NotNull
    public final TextField getUrlTextField() {
        return this.urlTextField;
    }

    @NotNull
    public final TextField getUrlOutField() {
        return this.urlOutField;
    }

    @NotNull
    public final TextArea getResponseTextArea() {
        return this.responseTextArea;
    }

    @NotNull
    public final PanChoiceBox getPostMethodChoiceBox() {
        return this.postMethodChoiceBox;
    }

    @NotNull
    public final TextArea getHeaderTextArea() {
        return this.headerTextArea;
    }

    @NotNull
    public final TextArea getBodyTextArea() {
        return this.bodyTextArea;
    }

    @NotNull
    public final SortedMap<String, Map<String, String>> getEnvMap() {
        return this.envMap;
    }

    public final void updateUrlOutTFfromUrlTextField(@NotNull String envMapKey) {
        Intrinsics.checkNotNullParameter(envMapKey, "envMapKey");
        this.envMapKey = envMapKey;
        String string = this.urlTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this.updateUrlOutTFfromFreshValue(envMapKey, string);
    }

    private final void updateUrlOutTFfromFreshValue(String envMapKey, String newValue) {
        Map props = (Map)this.envMap.get(envMapKey);
        Map map = props;
        if (map == null || map.isEmpty()) {
            this.updateUrlOutTFdirect(newValue);
        } else {
            String fullURL = new FlywheelBuilder().inputString(newValue).map(MapsKt.toMap(props)).construct().exec();
            this.updateUrlOutTFdirect(fullURL);
        }
    }

    public final void updateResponse(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Platform.runLater(() -> Floor.updateResponse$lambda$2(this, msg));
    }

    private final void updateUrlOutTFdirect(String value) {
        Platform.runLater(() -> Floor.updateUrlOutTFdirect$lambda$3(this, value));
    }

    private static final Unit _init_$lambda$0(Floor this$0, ObservableValue observableValue, String oldValue, String newValue) {
        this$0.updateUrlOutTFfromUrlTextField(this$0.envMapKey);
        System.out.println((Object)("textfield changed from " + oldValue + " to " + newValue + ", envMapKey: " + this$0.envMapKey + "."));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke(p0, p1, p2);
    }

    private static final void updateResponse$lambda$2(Floor this$0, String $msg) {
        this$0.responseTextArea.setText($msg);
    }

    private static final void updateUrlOutTFdirect$lambda$3(Floor this$0, String $value) {
        this$0.urlOutField.setText($value);
    }
}

