/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateLine;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/panopset/flywheel/CommandText;", "Lcom/panopset/flywheel/Command;", "template", "Lcom/panopset/flywheel/Template;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "text", "", "<init>", "(Lcom/panopset/flywheel/Template;Lcom/panopset/flywheel/TemplateLine;Ljava/lang/String;)V", "getDescription", "resolve", "", "sw", "Ljava/io/StringWriter;", "flywheel"})
@SourceDebugExtension(value={"SMAP\nCommandText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandText.kt\ncom/panopset/flywheel/CommandText\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class CommandText
extends Command {
    @NotNull
    private final String text;

    public CommandText(@NotNull Template template, @NotNull TemplateLine templateLine, @NotNull String text) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        Intrinsics.checkNotNullParameter(text, "text");
        super(template, templateLine);
        this.text = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getDescription() {
        StringReader sr = new StringReader(this.text);
        try {
            Closeable closeable = new BufferedReader(sr);
            Throwable throwable = null;
            try {
                Object object;
                BufferedReader br = (BufferedReader)closeable;
                boolean bl = false;
                String str = null;
                str = br.readLine();
                if (str == null) {
                    String string;
                    String it = string = "";
                    boolean bl2 = false;
                    str = it;
                    object = string;
                } else {
                    object = "CommandText:" + str;
                }
                String string = object;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
            String string = ex.getMessage();
            Intrinsics.checkNotNull(string);
            return string;
        }
    }

    @Override
    public void resolve(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        String rtn2 = this.text;
        if (!this.getTemplate().getFlywheel().isReplacementsSuppressed()) {
            Iterator<String[]> iterator2 = this.getTemplate().getFlywheel().getReplacements().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<String[]> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                String[] s;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                rtn2 = StringsKt.replace$default(rtn2, s[0], s[1], false, 4, null);
            }
        }
        sw.append(rtn2);
        String string = "%s %4d: %s";
        Object[] objectArray = new Object[]{this.getTemplate().getTemplateSource().getName(), this.getTemplate().getTemplateSource().getLine(), rtn2};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Logz.INSTANCE.debug(string2);
    }
}

