/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Stringop;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016R,\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/panopset/flywheel/ListAudit;", "", "<init>", "()V", "map", "", "", "", "getMap", "()Ljava/util/Map;", "setMap", "(Ljava/util/Map;)V", "names", "", "getNames", "()Ljava/util/Set;", "setNames", "(Ljava/util/Set;)V", "add", "", "name", "lines", "", "report", "getReport", "()Ljava/util/List;", "reportText", "getReportText", "()Ljava/lang/String;", "headerLine", "getHeaderLine", "flywheel"})
public final class ListAudit {
    @NotNull
    private Map<String, List<String>> map;
    @NotNull
    private Set<String> names;

    public ListAudit() {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        this.map = sortedMap;
        SortedSet sortedSet = Collections.synchronizedSortedSet(new TreeSet());
        Intrinsics.checkNotNullExpressionValue(sortedSet, "synchronizedSortedSet(...)");
        this.names = sortedSet;
    }

    @NotNull
    public final Map<String, List<String>> getMap() {
        return this.map;
    }

    public final void setMap(@NotNull Map<String, List<String>> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.map = map;
    }

    @NotNull
    public final Set<String> getNames() {
        return this.names;
    }

    public final void setNames(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.names = set;
    }

    public final void add(@NotNull String name, @NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lines, "lines");
        if (!this.names.contains(name)) {
            this.names.add(name);
        }
        for (String line : lines) {
            List listNames = this.map.get(line);
            if (listNames == null) {
                listNames = new ArrayList();
                ((ArrayList)listNames).add(name);
                this.map.put(line, listNames);
                continue;
            }
            if (listNames.contains(name)) continue;
            listNames.add(name);
        }
    }

    @NotNull
    public final List<String> getReport() {
        List rtn2 = new ArrayList();
        rtn2.add(this.getHeaderLine());
        for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            StringWriter sw = new StringWriter();
            sw.append(key);
            for (String name : this.names) {
                sw.append(",");
                if (!value.contains(name)) continue;
                sw.append("*");
            }
            rtn2.add(sw.toString());
        }
        return rtn2;
    }

    @NotNull
    public final String getReportText() {
        return Stringop.INSTANCE.listToString(this.getReport());
    }

    private final String getHeaderLine() {
        StringWriter sw = new StringWriter();
        for (String name : this.names) {
            String string = ",%s";
            Object[] objectArray = new Object[]{name};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            sw.append(string2);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

