/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandBuilder;
import com.panopset.flywheel.CommandText;
import com.panopset.flywheel.CommandUnkown;
import com.panopset.flywheel.Syntax;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateLine;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/panopset/flywheel/RawCommandLoader;", "", "template", "Lcom/panopset/flywheel/Template;", "<init>", "(Lcom/panopset/flywheel/Template;)V", "getTemplate", "()Lcom/panopset/flywheel/Template;", "tmplt", "queue", "Ljava/util/Deque;", "Lcom/panopset/flywheel/TemplateLine;", "commands", "", "Lcom/panopset/flywheel/Command;", "load", "", "flushQueue", "", "loadCommand", "command", "process", "templateLine", "skipTo", "pos", "", "flywheel"})
public final class RawCommandLoader {
    @NotNull
    private final Template template;
    @NotNull
    private final Template tmplt;
    @NotNull
    private final Deque<TemplateLine> queue;
    @NotNull
    private final List<Command> commands;

    public RawCommandLoader(@NotNull Template template) {
        Intrinsics.checkNotNullParameter(template, "template");
        this.tmplt = this.template = template;
        this.queue = new ArrayDeque();
        this.commands = new ArrayList();
    }

    @NotNull
    public final Template getTemplate() {
        return this.template;
    }

    @NotNull
    public final List<Command> load() {
        this.tmplt.getTemplateSource().reset();
        int templateIndex = 0;
        int lineNumber = 0;
        boolean firstTime = true;
        while (!this.tmplt.getTemplateSource().isDone()) {
            if (this.tmplt.getFlywheel().isStopped()) {
                return new ArrayList();
            }
            this.flushQueue();
            if (this.tmplt.getFlywheel().isStopped()) {
                return new ArrayList();
            }
            String line = this.tmplt.getTemplateSource().nextTemplateSourceLine();
            if (firstTime) {
                firstTime = false;
            } else if (this.tmplt.getTemplateRules().getLineBreaks()) {
                String string = "%s%s";
                Object[] objectArray = new Object[]{Stringop.INSTANCE.getEol(), line};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                line = string2;
            }
            this.process(new TemplateLine(line, templateIndex, lineNumber++));
            templateIndex += line.length();
        }
        this.flushQueue();
        return this.commands;
    }

    private final void flushQueue() {
        while (!this.queue.isEmpty()) {
            TemplateLine templateLine = this.queue.pop();
            Intrinsics.checkNotNullExpressionValue(templateLine, "pop(...)");
            this.process(templateLine);
            if (!this.tmplt.getFlywheel().isStopped()) continue;
            return;
        }
    }

    private final void loadCommand(Command command) {
        this.commands.add(command);
        Logz.INSTANCE.debug("Loading command: " + command);
    }

    private final void process(TemplateLine templateLine) {
        String line = templateLine.getLine();
        CharSequence charSequence = line;
        String string = Syntax.getOpenDirective();
        Intrinsics.checkNotNullExpressionValue(string, "getOpenDirective(...)");
        int openDirectiveLoc = StringsKt.indexOf$default(charSequence, string, 0, false, 6, null);
        CharSequence charSequence2 = line;
        String string2 = Syntax.getCloseDirective();
        Intrinsics.checkNotNullExpressionValue(string2, "getCloseDirective(...)");
        int closeDirectiveLoc = StringsKt.indexOf$default(charSequence2, string2, 0, false, 6, null);
        if (closeDirectiveLoc == -1 || openDirectiveLoc == -1) {
            this.loadCommand(new CommandText(this.tmplt, templateLine, line));
            return;
        }
        if (closeDirectiveLoc < openDirectiveLoc) {
            this.skipTo(templateLine, openDirectiveLoc);
            return;
        }
        int endOfDirective = closeDirectiveLoc + Syntax.getCloseDirective().length();
        if (openDirectiveLoc == 0) {
            Command command = new CommandBuilder().template(this.tmplt).source(templateLine, closeDirectiveLoc).construct();
            if (command instanceof CommandUnkown) {
                this.skipTo(templateLine, 1);
            } else {
                String string3 = line.substring(endOfDirective);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                String remainder = string3;
                this.loadCommand(command);
                if (((CharSequence)remainder).length() > 0) {
                    this.queue.push(new TemplateLine(remainder, templateLine.getTemplateCharIndex() + openDirectiveLoc, templateLine.getTemplateLineNumber()));
                }
            }
        } else {
            this.skipTo(templateLine, openDirectiveLoc);
        }
    }

    private final void skipTo(TemplateLine templateLine, int pos) {
        String line = templateLine.getLine();
        int templateCharIndex = templateLine.getTemplateCharIndex();
        int templateLineNumber = templateLine.getTemplateLineNumber();
        String string = line.substring(0, pos);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String skippedTextLine = string;
        this.loadCommand(new CommandText(this.tmplt, new TemplateLine(skippedTextLine, templateCharIndex, templateLineNumber), skippedTextLine));
        String string2 = line.substring(pos);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        this.queue.push(new TemplateLine(string2, templateCharIndex + pos, templateLineNumber));
    }
}

