/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Fileop;
import com.panopset.compat.Streamop;
import com.panopset.compat.Stringop;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005J \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\r2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\"\u0010\u0015\u001a\u00020\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0015\u001a\u00020\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u0012\u0010\u001a\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\u001b"}, d2={"Lcom/panopset/flywheel/Rezop;", "", "<init>", "()V", "loadFromRez", "", "clazz", "Ljava/lang/Class;", "rezPath", "loadListFromTextResource", "", "textStreamToList", "inputStream", "Ljava/io/InputStream;", "getResourceStream", "resourcePath", "getPackageResourcePath", "pkg", "Ljava/lang/Package;", "pkg2path", "dotName", "copyTextResourceToFile", "", "file", "Ljava/io/File;", "fileName", "pkg2resourcePath", "flywheel"})
public final class Rezop {
    @NotNull
    public static final Rezop INSTANCE = new Rezop();

    private Rezop() {
    }

    @NotNull
    public final String loadFromRez(@NotNull Class<?> clazz, @NotNull String rezPath) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(rezPath, "rezPath");
        InputStream inputStream = clazz.getResourceAsStream(rezPath);
        if (inputStream == null) {
            return "";
        }
        InputStream inputString = inputStream;
        return Streamop.INSTANCE.getTextFromStream(inputString);
    }

    @NotNull
    public final List<String> loadListFromTextResource(@NotNull Class<?> clazz, @NotNull String rezPath) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(rezPath, "rezPath");
        InputStream inputStream = clazz.getResourceAsStream(rezPath);
        if (inputStream == null) {
            return new ArrayList();
        }
        InputStream inputStream2 = inputStream;
        return this.textStreamToList(inputStream2);
    }

    @NotNull
    public final List<String> loadListFromTextResource(@NotNull String rezPath) {
        Intrinsics.checkNotNullParameter(rezPath, "rezPath");
        InputStream inputStream = Rezop.class.getResourceAsStream(rezPath);
        if (inputStream == null) {
            return new ArrayList();
        }
        InputStream inputStream2 = inputStream;
        return this.textStreamToList(inputStream2);
    }

    private final List<String> textStreamToList(InputStream inputStream) {
        String lines = Streamop.INSTANCE.getTextFromStream(inputStream);
        return Stringop.INSTANCE.stringToList(lines);
    }

    private final InputStream getResourceStream(Class<?> clazz, String resourcePath) {
        return clazz.getResourceAsStream(resourcePath);
    }

    @NotNull
    public final String getPackageResourcePath(@NotNull Package pkg) {
        Intrinsics.checkNotNullParameter(pkg, "pkg");
        StringWriter sw = new StringWriter();
        sw.append("/");
        String string = pkg.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        sw.append(this.pkg2path(string));
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String pkg2path(@NotNull String dotName) {
        Intrinsics.checkNotNullParameter(dotName, "dotName");
        return StringsKt.replace$default(dotName, ".", "/", false, 4, null);
    }

    public final void copyTextResourceToFile(@NotNull Class<?> clazz, @NotNull String resourcePath, @NotNull File file) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(file, "file");
        InputStream inputStream = this.getResourceStream(clazz, resourcePath);
        if (inputStream == null) {
            return;
        }
        InputStream inputStream2 = inputStream;
        Fileop.INSTANCE.copyInputStreamToFile(inputStream2, file);
    }

    public final void copyTextResourceToFile(@NotNull Class<?> clazz, @NotNull String resourcePath, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        InputStream inputStream = this.getResourceStream(clazz, resourcePath);
        if (inputStream == null) {
            return;
        }
        InputStream inputStream2 = inputStream;
        Fileop.INSTANCE.copyInputStreamToFile(inputStream2, fileName);
    }

    @NotNull
    public final String pkg2resourcePath(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        StringWriter sw = new StringWriter();
        sw.append("/");
        String string = clazz.getPackage().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        sw.append(StringsKt.replace$default(string, ".", "/", false, 4, null));
        sw.append("/");
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }
}

